package controllers.api

import play.api.mvc.Controller
import play.api.cache.Cache
import play.api.data.Form
import play.api.data.Forms._
import play.api.i18n.Messages
import play.api.libs.json.{JsObject, Json}
import play.api.libs.concurrent.Execution.Implicits._
import play.api.Logger

import scala.concurrent.Future
import scala.Some

import models.HomeBlock
import helpers.UUID

object HomeBlocks extends Controller with controllers.Secured {

  def findByLanguage(language: String) = IsAuthenticatedAsync(parse.anyContent) { implicit user => implicit request =>
    HomeBlock.findByLanguage(language).map { homeBlocks =>
      Ok(Json.toJson(homeBlocks.map { homeBlock => Json.toJson(homeBlock) }))
    }
  }

  def save = IsAuthenticatedAsync(parse.json) { implicit user => implicit request =>
    HomeBlock.update(request.body.as[HomeBlock]).map { homeBlocks =>
      Ok(Json.toJson(homeBlocks.map { homeBlock => Json.toJson(homeBlock) }))
    }
  }
}
