package helpers

import java.nio.ByteBuffer

case class UUID (
  uuid: java.util.UUID
) {
  def bytes: Array[Byte] = UUID.uuidToBytes(uuid)
  def string: String = uuid.toString()
}

object UUID {
  def apply(uuid: String)       = new UUID(java.util.UUID.fromString(uuid))
  def apply(bytes: Array[Byte]) = new UUID(bytesToUuid(bytes))

  def random = new UUID(java.util.UUID.randomUUID())

  private def uuidToBytes(uuid: java.util.UUID): Array[Byte] = {
    var bb = ByteBuffer.allocate(16)
    bb.putLong(uuid.getMostSignificantBits())
    bb.putLong(uuid.getLeastSignificantBits())
    bb.array()
  }

  private def uuidToBytes(uuidString: String): Array[Byte] = {
    var uuid = java.util.UUID.fromString(uuidString)
    var bb = ByteBuffer.allocate(16)
    bb.putLong(uuid.getMostSignificantBits())
    bb.putLong(uuid.getLeastSignificantBits())
    bb.array()
  }

  private def bytesToUuid(bytes: Array[Byte]): java.util.UUID = {
    var bb = ByteBuffer.wrap(bytes)
    new java.util.UUID(bb.getLong(), bb.getLong())
  }
}
