package helpers

import models.ContentModel

import scala.concurrent.duration._
import scala.concurrent.{Future, Await}
import scala.Some

object Util {

  def slugify(primaryTag: String, input: String): String = {
    if (input == "") {
      UUID.random.string
    }
    else {
      def encoder(s: String) = {
        val urlChars = "abcdefghijklmnopqrstuvwxyz0123456789-_.~"
        val buf = new StringBuilder
        for (c <- s) if (urlChars contains c) buf.append( c ) else if (c == ' ') buf.append( '-' )
        buf.toString
      }
      var slug = ""
      if (primaryTag != "") {
        slug += encoder(primaryTag.toLowerCase) + "/"
      }
      slug += encoder(input.toLowerCase)
      var futureContent = ContentModel.findBySlug(slug)
      var foundContent = Await.result(futureContent, 5 seconds)
      foundContent match {
        case Some(content) => {
          slug + "-" + UUID.random.string
        }
        case None => {
          slug
        }
      }
    }
  }

}
