package services.datasource

import com.github.mauricio.async.db.Configuration
import com.github.mauricio.async.db.postgresql.pool.PostgreSQLConnectionFactory
import play.api.{Application, GlobalSettings}
import com.github.mauricio.async.db.pool.{PoolConfiguration, ConnectionPool}
import com.github.mauricio.async.db.postgresql.util.URLParser
import com.github.mauricio.async.db.util.ExecutorServiceUtils.CachedExecutionContext
import models._
import play.api.Logger
import play.api.Play
import scala.concurrent.Future

object DataSource extends GlobalSettings {

  def config = Play.current.configuration

  val databaseConfiguration = {
    new Configuration(
      username = config.getString("db.postgresql.username").get,
      host = config.getString("db.postgresql.host").get,
      password = Some(config.getString("db.postgresql.password").get),
      database = Some(config.getString("db.postgresql.database").get)
    )
  }

  lazy val factory = new PostgreSQLConnectionFactory(databaseConfiguration)
  val pool = new ConnectionPool(factory, new PoolConfiguration(
    maxObjects = 80,
    maxIdle = 1000,
    maxQueueSize = 500)
  )

  override def onStop(app: Application) {
    pool.close
  }
}
