import play.api.{Application, GlobalSettings}
import play.api.i18n.Lang
import play.api.Play.current
import play.api.Play
import play.api.mvc.{EssentialAction, SimpleResult, RequestHeader}
import play.api.mvc.Results._
import play.api.libs.concurrent.Execution.Implicits._

import models.{MenuItem, HeaderItem, HomeBlock}

import helpers.UUID

import scala.concurrent.Future

object Global extends GlobalSettings {
  override def doFilter(action: EssentialAction): EssentialAction = EssentialAction { request =>
    implicit val lang = Lang(Play.current.configuration.getString("tagger.lang").get)
    action.apply(request).map(_.withLang(lang).asInstanceOf[SimpleResult])
  }

  override def onHandlerNotFound(request: RequestHeader): Future[SimpleResult] = {
    var language = Play.current.configuration.getString("tagger.language").get
    var title = "FLS 404 Not Found"

    val fMenuItems = MenuItem.findAllParents(language).flatMap { parentMenus =>
      Future.sequence(parentMenus.map { parentMenu =>
        for {
          cSubMenus <- MenuItem.findByParentId(parentMenu.id.string, language)
        } yield {
          (parentMenu, cSubMenus)
        }
      })
    }

    for {
      cHeaderItems <- HeaderItem.findByLanguage(language)
      cHomeBlock <- HomeBlock.findByLanguage(language)
      cMenuItems <- fMenuItems
    } yield {
      Ok(views.html.errors.notFound(title, request.path, cHeaderItems, cMenuItems, cHomeBlock.get))
    }
  }
}
