package ca.shiftfocus.krispii.web

import java.io.File
import org.parboiled.common.FileUtils
import scala.concurrent.duration._
import akka.actor._
import akka.pattern.ask
import spray.routing.{HttpService, RequestContext}
import spray.routing.directives.CachingDirectives
import spray.can.server.Stats
import spray.can.Http
import spray.httpx.marshalling.Marshaller
import spray.httpx.encoding.Gzip
import spray.util._
import spray.http._
import MediaTypes._
import CachingDirectives._
import akka.actor.Actor
import spray.routing._
import spray.http._
import spray.http.MediaTypes._
import scala.concurrent.ExecutionContext.Implicits.global
import ca.shiftfocus.krispii.web.admin.AdminRouter
import ca.shiftfocus.krispii.web.student.StudentRouter
import ca.shiftfocus.krispii.web.teacher.TeacherRouter

trait WebRouter
  extends HttpService
  with AdminRouter
  with TeacherRouter
  with CommonRouter
  with StudentRouter
{

  val routes = {
    commonRoutes ~
      studentRoutes ~
      teacherRoutes ~
      adminRoutes
  }

  val index =
    <html>
      <head>
        <title>Index Page</title>
        <script src="/assets/javascripts/libs/require.js" type="text/javascript"></script>
        <script src="/assets/javascripts/main.js" type="text/javascript"></script>
      </head>
      <body>
        <h1>This is a test page!</h1>
        <p>Lorum ipsum dolor sit amet.</p>
        <div id="chart-container"></div>
      </body>
    </html>
}