/*
 * Decompiled with CFR 0.152.
 */
package ca.shiftfocus.uuid;

import ca.shiftfocus.uuid.UUID;
import java.nio.ByteBuffer;
import play.api.data.validation.ValidationError;
import play.api.libs.json.JsError;
import play.api.libs.json.JsError$;
import play.api.libs.json.JsResult;
import play.api.libs.json.JsString;
import play.api.libs.json.JsSuccess;
import play.api.libs.json.JsSuccess$;
import play.api.libs.json.JsValue;
import play.api.libs.json.Reads;
import play.api.libs.json.Writes;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.Some;

public final class UUID$
implements Serializable {
    public static final UUID$ MODULE$;
    private final Object uuidReads;
    private final Object uuidWrites;

    static {
        new UUID$();
    }

    public Object uuidReads() {
        return this.uuidReads;
    }

    public Object uuidWrites() {
        return this.uuidWrites;
    }

    public UUID apply(String uuid) {
        return new UUID(java.util.UUID.fromString(uuid));
    }

    public UUID apply(byte[] bytes) {
        return new UUID(this.bytesToUuid(bytes));
    }

    public UUID random() {
        return new UUID(java.util.UUID.randomUUID());
    }

    public boolean isValid(String proposed) {
        String pattern = "^[0-9A-Fa-f]{8}\\-[0-9A-Fa-f]{4}\\-[0-9A-Fa-f]{4}\\-[0-9A-Fa-f]{4}\\-[0-9A-Fa-f]{12}$";
        return proposed.matches(pattern);
    }

    public byte[] ca$shiftfocus$uuid$UUID$$uuidToBytes(java.util.UUID uuid) {
        ByteBuffer bb = ByteBuffer.allocate(16);
        bb.putLong(uuid.getMostSignificantBits());
        bb.putLong(uuid.getLeastSignificantBits());
        return bb.array();
    }

    private byte[] uuidToBytes(String uuidString) {
        java.util.UUID uuid = java.util.UUID.fromString(uuidString);
        ByteBuffer bb = ByteBuffer.allocate(16);
        bb.putLong(uuid.getMostSignificantBits());
        bb.putLong(uuid.getLeastSignificantBits());
        return bb.array();
    }

    private java.util.UUID bytesToUuid(byte[] bytes) {
        ByteBuffer bb = ByteBuffer.wrap(bytes);
        return new java.util.UUID(bb.getLong(), bb.getLong());
    }

    public UUID apply(java.util.UUID uuid) {
        return new UUID(uuid);
    }

    public Option<java.util.UUID> unapply(UUID x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)x$0.uuid());
    }

    private Object readResolve() {
        return MODULE$;
    }

    private UUID$() {
        MODULE$ = this;
        this.uuidReads = new Reads<UUID>(){

            public <B> Reads<B> map(Function1<UUID, B> f) {
                return Reads.class.map((Reads)this, f);
            }

            public <B> Reads<B> flatMap(Function1<UUID, Reads<B>> f) {
                return Reads.class.flatMap((Reads)this, f);
            }

            public Reads<UUID> filter(Function1<UUID, Object> f) {
                return Reads.class.filter((Reads)this, f);
            }

            public Reads<UUID> filter(ValidationError error, Function1<UUID, Object> f) {
                return Reads.class.filter((Reads)this, (ValidationError)error, f);
            }

            public Reads<UUID> filterNot(Function1<UUID, Object> f) {
                return Reads.class.filterNot((Reads)this, f);
            }

            public Reads<UUID> filterNot(ValidationError error, Function1<UUID, Object> f) {
                return Reads.class.filterNot((Reads)this, (ValidationError)error, f);
            }

            public <B> Reads<B> collect(ValidationError error, PartialFunction<UUID, B> f) {
                return Reads.class.collect((Reads)this, (ValidationError)error, f);
            }

            public Reads<UUID> orElse(Reads<UUID> v) {
                return Reads.class.orElse((Reads)this, v);
            }

            public <B extends JsValue> Reads<UUID> compose(Reads<B> rb) {
                return Reads.class.compose((Reads)this, rb);
            }

            public <B> Reads<B> andThen(Reads<B> rb, Predef$.less.colon.less<UUID, JsValue> witness) {
                return Reads.class.andThen((Reads)this, rb, witness);
            }

            public JsResult<UUID> reads(JsValue json) {
                JsError jsError;
                JsValue jsValue = json;
                if (jsValue instanceof JsString) {
                    JsString jsString = (JsString)jsValue;
                    String s = jsString.value();
                    jsError = new JsSuccess((Object)UUID$.MODULE$.apply(s), JsSuccess$.MODULE$.apply$default$2());
                } else {
                    jsError = JsError$.MODULE$.apply("String value expected.");
                }
                return jsError;
            }
            {
                Reads.class.$init$((Reads)this);
            }
        };
        this.uuidWrites = new Writes<UUID>(){

            public Writes<UUID> transform(Function1<JsValue, JsValue> transformer) {
                return Writes.class.transform((Writes)this, transformer);
            }

            public Writes<UUID> transform(Writes<JsValue> transformer) {
                return Writes.class.transform((Writes)this, transformer);
            }

            public JsValue writes(UUID uuid) {
                return new JsString(uuid.string());
            }
            {
                Writes.class.$init$((Writes)this);
            }
        };
    }
}

