/*
 * Decompiled with CFR 0.152.
 */
package ca.shiftfocus.uuid;

import ca.shiftfocus.uuid.UUID;
import java.nio.ByteBuffer;
import play.api.libs.json.JsError$;
import play.api.libs.json.JsResult;
import play.api.libs.json.JsString;
import play.api.libs.json.JsSuccess;
import play.api.libs.json.JsSuccess$;
import play.api.libs.json.JsValue;
import play.api.libs.json.JsonValidationError;
import play.api.libs.json.Reads;
import play.api.libs.json.Writes;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.Some;

public final class UUID$
implements Serializable {
    public static UUID$ MODULE$;
    private final Reads<UUID> uuidReads;
    private final Writes<UUID> uuidWrites;

    static {
        new UUID$();
    }

    public Reads<UUID> uuidReads() {
        return this.uuidReads;
    }

    public Writes<UUID> uuidWrites() {
        return this.uuidWrites;
    }

    public UUID apply(String uuid) {
        return new UUID(java.util.UUID.fromString(uuid));
    }

    public UUID apply(byte[] bytes) {
        return new UUID(this.bytesToUuid(bytes));
    }

    public UUID random() {
        return new UUID(java.util.UUID.randomUUID());
    }

    public boolean isValid(String proposed) {
        String pattern = "^[0-9A-Fa-f]{8}\\-[0-9A-Fa-f]{4}\\-[0-9A-Fa-f]{4}\\-[0-9A-Fa-f]{4}\\-[0-9A-Fa-f]{12}$";
        return proposed.matches(pattern);
    }

    public byte[] ca$shiftfocus$uuid$UUID$$uuidToBytes(java.util.UUID uuid) {
        ByteBuffer bb = ByteBuffer.allocate(16);
        bb.putLong(uuid.getMostSignificantBits());
        bb.putLong(uuid.getLeastSignificantBits());
        return bb.array();
    }

    private byte[] uuidToBytes(String uuidString) {
        java.util.UUID uuid = java.util.UUID.fromString(uuidString);
        ByteBuffer bb = ByteBuffer.allocate(16);
        bb.putLong(uuid.getMostSignificantBits());
        bb.putLong(uuid.getLeastSignificantBits());
        return bb.array();
    }

    private java.util.UUID bytesToUuid(byte[] bytes) {
        ByteBuffer bb = ByteBuffer.wrap(bytes);
        return new java.util.UUID(bb.getLong(), bb.getLong());
    }

    public UUID apply(java.util.UUID uuid) {
        return new UUID(uuid);
    }

    public Option<java.util.UUID> unapply(UUID x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)x$0.uuid());
    }

    private Object readResolve() {
        return MODULE$;
    }

    private UUID$() {
        MODULE$ = this;
        this.uuidReads = new Reads<UUID>(){

            public <B> Reads<B> map(Function1<UUID, B> f) {
                return Reads.map$((Reads)this, f);
            }

            public <B> Reads<B> flatMap(Function1<UUID, Reads<B>> f) {
                return Reads.flatMap$((Reads)this, f);
            }

            public Reads<UUID> filter(Function1<UUID, Object> f) {
                return Reads.filter$((Reads)this, f);
            }

            public Reads<UUID> filter(JsonValidationError error, Function1<UUID, Object> f) {
                return Reads.filter$((Reads)this, (JsonValidationError)error, f);
            }

            public Reads<UUID> filterNot(Function1<UUID, Object> f) {
                return Reads.filterNot$((Reads)this, f);
            }

            public Reads<UUID> filterNot(JsonValidationError error, Function1<UUID, Object> f) {
                return Reads.filterNot$((Reads)this, (JsonValidationError)error, f);
            }

            public <B> Reads<B> collect(JsonValidationError error, PartialFunction<UUID, B> f) {
                return Reads.collect$((Reads)this, (JsonValidationError)error, f);
            }

            public Reads<UUID> orElse(Reads<UUID> v) {
                return Reads.orElse$((Reads)this, v);
            }

            public <B extends JsValue> Reads<UUID> compose(Reads<B> rb) {
                return Reads.compose$((Reads)this, rb);
            }

            public <B extends JsValue> Reads<UUID> composeWith(Reads<B> rb) {
                return Reads.composeWith$((Reads)this, rb);
            }

            public Reads<UUID> preprocess(PartialFunction<JsValue, JsValue> f) {
                return Reads.preprocess$((Reads)this, f);
            }

            public <B> Reads<B> andThen(Reads<B> rb, Predef$.less.colon.less<UUID, JsValue> witness) {
                return Reads.andThen$((Reads)this, rb, witness);
            }

            public <B> Reads<B> widen() {
                return Reads.widen$((Reads)this);
            }

            public JsResult<UUID> reads(JsValue json) {
                JsValue jsValue = json;
                if (jsValue instanceof JsString) {
                    JsString jsString = (JsString)jsValue;
                    String s = jsString.value();
                    return new JsSuccess((Object)UUID$.MODULE$.apply(s), JsSuccess$.MODULE$.apply$default$2());
                }
                return JsError$.MODULE$.apply("String value expected.");
            }
            {
                Reads.$init$((Reads)this);
            }
        };
        this.uuidWrites = new Writes<UUID>(){

            public <B> Writes<B> contramap(Function1<B, UUID> f) {
                return Writes.contramap$((Writes)this, f);
            }

            public <B extends UUID> Writes<B> narrow() {
                return Writes.narrow$((Writes)this);
            }

            public Writes<UUID> transform(Function1<JsValue, JsValue> transformer) {
                return Writes.transform$((Writes)this, transformer);
            }

            public Writes<UUID> transform(Writes<JsValue> transformer) {
                return Writes.transform$((Writes)this, transformer);
            }

            public JsValue writes(UUID uuid) {
                return new JsString(uuid.string());
            }
            {
                Writes.$init$((Writes)this);
            }
        };
    }
}

