/*
 * Decompiled with CFR 0.152.
 */
package webcrank.password.internal;

import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Serializable;
import scala.Some;
import webcrank.password.BCrypt;
import webcrank.password.PBKDF2;
import webcrank.password.PasswordSpec;
import webcrank.password.SCrypt;
import webcrank.password.internal.Algorithms$bcrypt$;
import webcrank.password.internal.Algorithms$pbkdf2$;
import webcrank.password.internal.Algorithms$scrypt$;
import webcrank.password.internal.Crypt;

public final class Crypt$
implements Serializable {
    public static final Crypt$ MODULE$;

    static {
        new Crypt$();
    }

    public Crypt fromSpec(PasswordSpec spec) {
        PasswordSpec passwordSpec;
        block5: {
            Crypt crypt;
            block3: {
                block4: {
                    block2: {
                        passwordSpec = spec;
                        if (!(passwordSpec instanceof SCrypt)) break block2;
                        SCrypt sCrypt = (SCrypt)passwordSpec;
                        crypt = new Crypt((Function1<String, String>)new Serializable(sCrypt){
                            private final SCrypt x2$1;

                            public final String apply(String x$1) {
                                return Algorithms$scrypt$.MODULE$.crypt(x$1, this.x2$1);
                            }
                            {
                                this.x2$1 = x2$1;
                            }
                        });
                        break block3;
                    }
                    if (!(passwordSpec instanceof BCrypt)) break block4;
                    BCrypt bCrypt = (BCrypt)passwordSpec;
                    crypt = new Crypt((Function1<String, String>)new Serializable(bCrypt){
                        private final BCrypt x6$1;

                        public final String apply(String x$2) {
                            return Algorithms$bcrypt$.MODULE$.crypt(x$2, this.x6$1);
                        }
                        {
                            this.x6$1 = x6$1;
                        }
                    });
                    break block3;
                }
                if (!(passwordSpec instanceof PBKDF2)) break block5;
                PBKDF2 pBKDF2 = (PBKDF2)passwordSpec;
                crypt = new Crypt((Function1<String, String>)new Serializable(pBKDF2){
                    private final PBKDF2 x8$1;

                    public final String apply(String x$3) {
                        return Algorithms$pbkdf2$.MODULE$.crypt(x$3, this.x8$1);
                    }
                    {
                        this.x8$1 = x8$1;
                    }
                });
            }
            return crypt;
        }
        throw new MatchError((Object)passwordSpec);
    }

    public Crypt apply(Function1<String, String> crypt) {
        return new Crypt(crypt);
    }

    public Option<Function1<String, String>> unapply(Crypt x$0) {
        return x$0 == null ? None$.MODULE$ : new Some(x$0.crypt());
    }

    private Object readResolve() {
        return MODULE$;
    }

    private Crypt$() {
        MODULE$ = this;
    }
}

