/*
 * Decompiled with CFR 0.152.
 */
package webcrank.password.internal;

import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Serializable;
import scala.Some;
import webcrank.password.BCrypt;
import webcrank.password.PBKDF2;
import webcrank.password.PasswordSpec;
import webcrank.password.SCrypt;
import webcrank.password.internal.Algorithms$bcrypt$;
import webcrank.password.internal.Algorithms$pbkdf2$;
import webcrank.password.internal.Algorithms$scrypt$;
import webcrank.password.internal.Crypt;

public final class Crypt$
implements Serializable {
    public static Crypt$ MODULE$;

    static {
        new Crypt$();
    }

    public Crypt fromSpec(PasswordSpec spec) {
        PasswordSpec passwordSpec = spec;
        if (passwordSpec instanceof SCrypt) {
            SCrypt sCrypt = (SCrypt)passwordSpec;
            return new Crypt((Function1<String, String>)(Function1 & java.io.Serializable & Serializable)x$1 -> Algorithms$scrypt$.MODULE$.crypt((String)x$1, sCrypt));
        }
        if (passwordSpec instanceof BCrypt) {
            BCrypt bCrypt = (BCrypt)passwordSpec;
            return new Crypt((Function1<String, String>)(Function1 & java.io.Serializable & Serializable)x$2 -> Algorithms$bcrypt$.MODULE$.crypt((String)x$2, bCrypt));
        }
        if (passwordSpec instanceof PBKDF2) {
            PBKDF2 pBKDF2 = (PBKDF2)passwordSpec;
            return new Crypt((Function1<String, String>)(Function1 & java.io.Serializable & Serializable)x$3 -> Algorithms$pbkdf2$.MODULE$.crypt((String)x$3, pBKDF2));
        }
        throw new MatchError((Object)passwordSpec);
    }

    public Crypt apply(Function1<String, String> crypt) {
        return new Crypt(crypt);
    }

    public Option<Function1<String, String>> unapply(Crypt x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some(x$0.crypt());
    }

    private Object readResolve() {
        return MODULE$;
    }

    private Crypt$() {
        MODULE$ = this;
    }
}

