/*
 * Decompiled with CFR 0.152.
 */
package com.github.mauricio.async.db.mysql;

import com.github.mauricio.async.db.Configuration;
import com.github.mauricio.async.db.Connection;
import com.github.mauricio.async.db.QueryResult;
import com.github.mauricio.async.db.ResultSet;
import com.github.mauricio.async.db.exceptions.ConnectionStillRunningQueryException;
import com.github.mauricio.async.db.exceptions.DatabaseException;
import com.github.mauricio.async.db.exceptions.InsufficientParametersException;
import com.github.mauricio.async.db.mysql.MySQLConnection$;
import com.github.mauricio.async.db.mysql.MySQLQueryResult;
import com.github.mauricio.async.db.mysql.MySQLQueryResult$;
import com.github.mauricio.async.db.mysql.codec.MySQLConnectionHandler;
import com.github.mauricio.async.db.mysql.codec.MySQLHandlerDelegate;
import com.github.mauricio.async.db.mysql.exceptions.MySQLException;
import com.github.mauricio.async.db.mysql.message.client.AuthenticationSwitchResponse;
import com.github.mauricio.async.db.mysql.message.client.HandshakeResponseMessage;
import com.github.mauricio.async.db.mysql.message.client.QueryMessage;
import com.github.mauricio.async.db.mysql.message.client.QuitMessage$;
import com.github.mauricio.async.db.mysql.message.server.AuthenticationSwitchRequest;
import com.github.mauricio.async.db.mysql.message.server.EOFMessage;
import com.github.mauricio.async.db.mysql.message.server.ErrorMessage;
import com.github.mauricio.async.db.mysql.message.server.HandshakeMessage;
import com.github.mauricio.async.db.mysql.message.server.OkMessage;
import com.github.mauricio.async.db.mysql.util.CharsetMapper;
import com.github.mauricio.async.db.util.ChannelFutureTransformer$;
import com.github.mauricio.async.db.util.Version;
import com.github.mauricio.async.db.util.Version$;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.EventLoopGroup;
import java.nio.charset.Charset;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0001\tUx!B\u0001\u0003\u0011\u0003y\u0011aD'z'Fc5i\u001c8oK\u000e$\u0018n\u001c8\u000b\u0005\r!\u0011!B7zgFd'BA\u0003\u0007\u0003\t!'M\u0003\u0002\b\u0011\u0005)\u0011m]=oG*\u0011\u0011BC\u0001\t[\u0006,(/[2j_*\u00111\u0002D\u0001\u0007O&$\b.\u001e2\u000b\u00035\t1aY8n\u0007\u0001\u0001\"\u0001E\t\u000e\u0003\t1QA\u0005\u0002\t\u0002M\u0011q\"T=T#2\u001buN\u001c8fGRLwN\\\n\u0003#Q\u0001\"!\u0006\r\u000e\u0003YQ\u0011aF\u0001\u0006g\u000e\fG.Y\u0005\u00033Y\u0011a!\u00118z%\u00164\u0007\"B\u000e\u0012\t\u0003a\u0012A\u0002\u001fj]&$h\bF\u0001\u0010\u0011\u001dq\u0012C1A\u0005\u0006}\tqaQ8v]R,'/F\u0001!!\t\t#&D\u0001#\u0015\t\u0019C%\u0001\u0004bi>l\u0017n\u0019\u0006\u0003K\u0019\n!bY8oGV\u0014(/\u001a8u\u0015\t9\u0003&\u0001\u0003vi&d'\"A\u0015\u0002\t)\fg/Y\u0005\u0003W\t\u0012!\"\u0011;p[&\u001cGj\u001c8h\u0011\u0019i\u0013\u0003)A\u0007A\u0005A1i\\;oi\u0016\u0014\b\u0005C\u00040#\t\u0007IQ\u0001\u0019\u0002'5K7M]8tK\u000e|g\u000eZ:WKJ\u001c\u0018n\u001c8\u0016\u0003E\u0002\"A\r\u001b\u000e\u0003MR!a\n\u0003\n\u0005U\u001a$a\u0002,feNLwN\u001c\u0005\u0007oE\u0001\u000bQB\u0019\u0002)5K7M]8tK\u000e|g\u000eZ:WKJ\u001c\u0018n\u001c8!\u0011\u001dI\u0014C1A\u0005\u0006i\n1\u0001\\8h+\u0005Y\u0004C\u0001\u001fB\u001b\u0005i$B\u0001 @\u0003\u0015\u0019HN\u001a\u001bk\u0015\u0005\u0001\u0015aA8sO&\u0011!)\u0010\u0002\u0007\u0019><w-\u001a:\t\r\u0011\u000b\u0002\u0015!\u0004<\u0003\u0011awn\u001a\u0011\t\u000f\u0019\u000b\u0012\u0013!C\u0001\u000f\u0006YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uII*\u0012\u0001\u0013\u0016\u0003\u0013:\u0003\"A\u0013'\u000e\u0003-S!a\n\u0002\n\u00055[%!D\"iCJ\u001cX\r^'baB,'oK\u0001P!\t\u0001V+D\u0001R\u0015\t\u00116+A\u0005v]\u000eDWmY6fI*\u0011AKF\u0001\u000bC:tw\u000e^1uS>t\u0017B\u0001,R\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a\u0005\b1F\t\n\u0011\"\u0001Z\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%gU\t!L\u000b\u0002\\\u001dB\u0011AlY\u0007\u0002;*\u0011alX\u0001\bG\"\fgN\\3m\u0015\t\u0001\u0017-A\u0003oKR$\u0018PC\u0001c\u0003\tIw.\u0003\u0002e;\nqQI^3oi2{w\u000e]$s_V\u0004\bb\u00024\u0012#\u0003%\taZ\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001b\u0016\u0003!T#!\u001b(\u0011\u0005)dW\"A6\u000b\u0005\u00152\u0012BA7l\u0005A)\u00050Z2vi&|gnQ8oi\u0016DHO\u0002\u0003\u0013\u0005\u0001y7\u0003\u00028\u0015aZ\u0004\"!\u001d;\u000e\u0003IT!a\u001d\u0002\u0002\u000b\r|G-Z2\n\u0005U\u0014(\u0001F'z'Fc\u0005*\u00198eY\u0016\u0014H)\u001a7fO\u0006$X\r\u0005\u0002xq6\tA!\u0003\u0002z\t\tQ1i\u001c8oK\u000e$\u0018n\u001c8\t\u0011mt'\u0011!Q\u0001\nq\fQbY8oM&<WO]1uS>t\u0007CA<~\u0013\tqHAA\u0007D_:4\u0017nZ;sCRLwN\u001c\u0005\n\u0003\u0003q'\u0011!Q\u0001\n%\u000bQb\u00195beN,G/T1qa\u0016\u0014\b\"CA\u0003]\n\u0005\t\u0015!\u0003\\\u0003\u00159'o\\;q\u0011%\tIA\u001cB\u0001B\u0003%\u0011.\u0001\tfq\u0016\u001cW\u000f^5p]\u000e{g\u000e^3yi\"11D\u001cC\u0001\u0003\u001b!\"\"a\u0004\u0002\u0012\u0005M\u0011QCA\f!\t\u0001b\u000e\u0003\u0004|\u0003\u0017\u0001\r\u0001 \u0005\n\u0003\u0003\tY\u0001%AA\u0002%C\u0011\"!\u0002\u0002\fA\u0005\t\u0019A.\t\u0013\u0005%\u00111\u0002I\u0001\u0002\u0004I\u0007\"CA\u000e]\n\u0007IQBA\u000f\u0003=\u0019wN\u001c8fGRLwN\\\"pk:$XCAA\u0010!\r)\u0012\u0011E\u0005\u0004\u0003G1\"\u0001\u0002'p]\u001eD\u0001\"a\noA\u00035\u0011qD\u0001\u0011G>tg.Z2uS>t7i\\;oi\u0002B\u0011\"a\u000bo\u0005\u0004%i!!\f\u0002\u0019\r|gN\\3di&|g.\u00133\u0016\u0005\u0005=\u0002\u0003BA\u0019\u0003oq1!FA\u001a\u0013\r\t)DF\u0001\u0007!J,G-\u001a4\n\t\u0005e\u00121\b\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005Ub\u0003\u0003\u0005\u0002@9\u0004\u000bQBA\u0018\u00035\u0019wN\u001c8fGRLwN\\%eA!I\u00111\t8C\u0002\u0013-\u0011QI\u0001\rS:$XM\u001d8bYB{w\u000e\\\u000b\u0002S\"9\u0011\u0011\n8!\u0002\u0013I\u0017!D5oi\u0016\u0014h.\u00197Q_>d\u0007\u0005C\u0005\u0002N9\u0014\r\u0011\"\u0004\u0002P\u0005\t2m\u001c8oK\u000e$\u0018n\u001c8IC:$G.\u001a:\u0016\u0005\u0005E\u0003cA9\u0002T%\u0019\u0011Q\u000b:\u0003-5K8+\u0015'D_:tWm\u0019;j_:D\u0015M\u001c3mKJD\u0001\"!\u0017oA\u00035\u0011\u0011K\u0001\u0013G>tg.Z2uS>t\u0007*\u00198eY\u0016\u0014\b\u0005C\u0005\u0002^9\u0014\r\u0011\"\u0004\u0002`\u0005\t2m\u001c8oK\u000e$\u0018n\u001c8Qe>l\u0017n]3\u0016\u0005\u0005\u0005\u0004\u0003\u00026\u0002dYL1!!\u001al\u0005\u001d\u0001&o\\7jg\u0016D\u0001\"!\u001boA\u00035\u0011\u0011M\u0001\u0013G>tg.Z2uS>t\u0007K]8nSN,\u0007\u0005C\u0005\u0002n9\u0014\r\u0011\"\u0004\u0002`\u0005!B-[:d_:tWm\u0019;j_:\u0004&o\\7jg\u0016D\u0001\"!\u001doA\u00035\u0011\u0011M\u0001\u0016I&\u001c8m\u001c8oK\u000e$\u0018n\u001c8Qe>l\u0017n]3!\u0011%\t)H\u001cb\u0001\n\u0013\t9(A\u000brk\u0016\u0014\u0018\u0010\u0015:p[&\u001cXMU3gKJ,gnY3\u0016\u0005\u0005e\u0004#B\u0011\u0002|\u0005}\u0014bAA?E\ty\u0011\t^8nS\u000e\u0014VMZ3sK:\u001cW\rE\u0003\u0016\u0003\u0003\u000b))C\u0002\u0002\u0004Z\u0011aa\u00149uS>t\u0007#\u00026\u0002d\u0005\u001d\u0005cA<\u0002\n&\u0019\u00111\u0012\u0003\u0003\u0017E+XM]=SKN,H\u000e\u001e\u0005\t\u0003\u001fs\u0007\u0015!\u0003\u0002z\u00051\u0012/^3ssB\u0013x.\\5tKJ+g-\u001a:f]\u000e,\u0007\u0005C\u0005\u0002\u0014:\u0004\r\u0011\"\u0003\u0002\u0016\u0006I1m\u001c8oK\u000e$X\rZ\u000b\u0003\u0003/\u00032!FAM\u0013\r\tYJ\u0006\u0002\b\u0005>|G.Z1o\u0011%\tyJ\u001ca\u0001\n\u0013\t\t+A\u0007d_:tWm\u0019;fI~#S-\u001d\u000b\u0005\u0003G\u000bI\u000bE\u0002\u0016\u0003KK1!a*\u0017\u0005\u0011)f.\u001b;\t\u0015\u0005-\u0016QTA\u0001\u0002\u0004\t9*A\u0002yIEB\u0001\"a,oA\u0003&\u0011qS\u0001\u000bG>tg.Z2uK\u0012\u0004\u0003\"CAZ]\u0002\u0007I\u0011BA[\u00039yF.Y:u\u000bb\u001cW\r\u001d;j_:,\"!a.\u0011\t\u0005e\u0016\u0011\u001a\b\u0005\u0003w\u000b)M\u0004\u0003\u0002>\u0006\rWBAA`\u0015\r\t\tMD\u0001\u0007yI|w\u000e\u001e \n\u0003]I1!a2\u0017\u0003\u001d\u0001\u0018mY6bO\u0016LA!a3\u0002N\nIA\u000b\u001b:po\u0006\u0014G.\u001a\u0006\u0004\u0003\u000f4\u0002\"CAi]\u0002\u0007I\u0011BAj\u0003IyF.Y:u\u000bb\u001cW\r\u001d;j_:|F%Z9\u0015\t\u0005\r\u0016Q\u001b\u0005\u000b\u0003W\u000by-!AA\u0002\u0005]\u0006\u0002CAm]\u0002\u0006K!a.\u0002\u001f}c\u0017m\u001d;Fq\u000e,\u0007\u000f^5p]\u0002B\u0001\"!8o\u0001\u0004%I\u0001M\u0001\u000eg\u0016\u0014h/\u001a:WKJ\u001c\u0018n\u001c8\t\u0013\u0005\u0005h\u000e1A\u0005\n\u0005\r\u0018!E:feZ,'OV3sg&|gn\u0018\u0013fcR!\u00111UAs\u0011%\tY+a8\u0002\u0002\u0003\u0007\u0011\u0007C\u0004\u0002j:\u0004\u000b\u0015B\u0019\u0002\u001dM,'O^3s-\u0016\u00148/[8oA!1\u0011Q\u001e8\u0005\u0002A\nqA^3sg&|g\u000eC\u0004\u0002r:$\t!!.\u0002\u001b1\f7\u000f^#yG\u0016\u0004H/[8o\u0011\u001d\t)P\u001cC\u0001\u0003;\tQaY8v]RDq!!?o\t\u0003\tY0A\u0004d_:tWm\u0019;\u0016\u0005\u0005u\b\u0003\u00026\u0002\u0000ZL1A!\u0001l\u0005\u00191U\u000f^;sK\"9!Q\u00018\u0005\u0002\u0005m\u0018!B2m_N,\u0007bBAJ]\u0012\u0005#\u0011\u0002\u000b\u0005\u0003G\u0013Y\u0001\u0003\u0005\u0003\u000e\t\u001d\u0001\u0019\u0001B\b\u0003\r\u0019G\u000f\u001f\t\u00049\nE\u0011b\u0001B\n;\n)2\t[1o]\u0016d\u0007*\u00198eY\u0016\u00148i\u001c8uKb$\bb\u0002B\f]\u0012\u0005#\u0011D\u0001\u0010Kb\u001cW\r\u001d;j_:\u001c\u0015-^4iiR!\u00111\u0015B\u000e\u0011!\u0011iB!\u0006A\u0002\u0005]\u0016!\u0003;ie><\u0018M\u00197f\u0011\u001d\u0011\tC\u001cC!\u0005G\tqa\u001c8FeJ|'\u000f\u0006\u0003\u0002$\n\u0015\u0002\u0002\u0003B\u0014\u0005?\u0001\rA!\u000b\u0002\u000f5,7o]1hKB!!1\u0006B\u001a\u001b\t\u0011iC\u0003\u0003\u00030\tE\u0012AB:feZ,'OC\u0002\u0003(\tIAA!\u000e\u0003.\taQI\u001d:pe6+7o]1hK\"9!\u0011\b8\u0005\n\tm\u0012\u0001D:fi\u0016C8-\u001a9uS>tG\u0003BAR\u0005{A\u0001Ba\u0010\u00038\u0001\u0007\u0011qW\u0001\u0002i\"9!1\t8\u0005B\t\u0015\u0013\u0001B8o\u001f.$B!a)\u0003H!A!q\u0005B!\u0001\u0004\u0011I\u0005\u0005\u0003\u0003,\t-\u0013\u0002\u0002B'\u0005[\u0011\u0011bT6NKN\u001c\u0018mZ3\t\u000f\tEc\u000e\"\u0001\u0003T\u0005)qN\\#P\rR!\u00111\u0015B+\u0011!\u00119Ca\u0014A\u0002\t]\u0003\u0003\u0002B\u0016\u00053JAAa\u0017\u0003.\tQQi\u0014$NKN\u001c\u0018mZ3\t\u000f\t}c\u000e\"\u0011\u0003b\u0005YqN\u001c%b]\u0012\u001c\b.Y6f)\u0011\t\u0019Ka\u0019\t\u0011\t\u001d\"Q\fa\u0001\u0005K\u0002BAa\u000b\u0003h%!!\u0011\u000eB\u0017\u0005AA\u0015M\u001c3tQ\u0006\\W-T3tg\u0006<W\rC\u0004\u0003n9$\tEa\u001c\u0002)M<\u0018\u000e^2i\u0003V$\b.\u001a8uS\u000e\fG/[8o)\u0011\t\u0019K!\u001d\t\u0011\t\u001d\"1\u000ea\u0001\u0005g\u0002BAa\u000b\u0003v%!!q\u000fB\u0017\u0005m\tU\u000f\u001e5f]RL7-\u0019;j_:\u001cv/\u001b;dQJ+\u0017/^3ti\"9!1\u00108\u0005\u0002\tu\u0014!C:f]\u0012\fV/\u001a:z)\u0011\u0011yH!!\u0011\u000b)\fy0a\"\t\u0011\t\r%\u0011\u0010a\u0001\u0003_\tQ!];fefDqAa\"o\t\u0013\u0011I)\u0001\u0006bI\u0012$\u0016.\\3pkR$B!a)\u0003\f\"A!Q\u0012BC\u0001\u0004\t))A\u0004qe>l\u0017n]3\t\u000f\tEe\u000e\"\u0003\u0003\u0014\u0006\u0001b-Y5m#V,'/\u001f)s_6L7/\u001a\u000b\u0005\u0003G\u0013)\n\u0003\u0005\u0003@\t=\u0005\u0019AA\\\u0011\u001d\u0011IJ\u001cC\u0005\u00057\u000b1c];dG\u0016,G-U;fef\u0004&o\\7jg\u0016$B!a)\u0003\u001e\"A!q\u0014BL\u0001\u0004\t9)A\u0006rk\u0016\u0014\u0018PU3tk2$\bb\u0002BR]\u0012\u0005\u0011QS\u0001\u000bSN\fV/\u001a:zS:<\u0007b\u0002BT]\u0012\u0005!\u0011V\u0001\f_:\u0014Vm];miN+G\u000f\u0006\u0004\u0002$\n-&Q\u0017\u0005\t\u0005[\u0013)\u000b1\u0001\u00030\u0006I!/Z:vYR\u001cV\r\u001e\t\u0004o\nE\u0016b\u0001BZ\t\tI!+Z:vYR\u001cV\r\u001e\u0005\t\u0005O\u0011)\u000b1\u0001\u0003X!9!\u0011\u00188\u0005\u0002\u0005m\u0018A\u00033jg\u000e|gN\\3di\"9!Q\u00188\u0005\u0002\u0005U\u0015aC5t\u0007>tg.Z2uK\u0012DqA!1o\t\u0003\u0011\u0019-A\u000btK:$\u0007K]3qCJ,Gm\u0015;bi\u0016lWM\u001c;\u0015\r\t}$Q\u0019Bd\u0011!\u0011\u0019Ia0A\u0002\u0005=\u0002B\u0003Be\u0005\u007f\u0003\n\u00111\u0001\u0003L\u00061a/\u00197vKN\u0004b!!/\u0003N\nE\u0017\u0002\u0002Bh\u0003\u001b\u00141aU3r!\r)\"1[\u0005\u0004\u0005+4\"aA!os\"9!\u0011\u001c8\u0005B\tm\u0017\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u0005=\u0002b\u0002Bp]\u0012%!\u0011]\u0001\u0018m\u0006d\u0017\u000eZ1uK&\u001b(+Z1es\u001a{'/U;fef$\"!a)\t\u000f\t\u0015h\u000e\"\u0003\u0003h\u0006a\u0011/^3ssB\u0013x.\\5tKV\u0011\u0011q\u0010\u0005\b\u0005WtG\u0011\u0002Bw\u0003=\u0019X\r^)vKJL\bK]8nSN,G\u0003BAR\u0005_D\u0001B!$\u0003j\u0002\u0007\u0011Q\u0011\u0005\b\u0005gtG\u0011\u0002Bt\u0003E\u0019G.Z1s#V,'/\u001f)s_6L7/\u001a")
public class MySQLConnection
implements MySQLHandlerDelegate,
Connection {
    public final Configuration com$github$mauricio$async$db$mysql$MySQLConnection$$configuration;
    private final long connectionCount;
    private final String connectionId;
    private final ExecutionContext com$github$mauricio$async$db$mysql$MySQLConnection$$internalPool;
    private final MySQLConnectionHandler com$github$mauricio$async$db$mysql$MySQLConnection$$connectionHandler;
    private final Promise<Connection> com$github$mauricio$async$db$mysql$MySQLConnection$$connectionPromise;
    private final Promise<Connection> com$github$mauricio$async$db$mysql$MySQLConnection$$disconnectionPromise;
    private final AtomicReference<Option<Promise<QueryResult>>> queryPromiseReference;
    private boolean connected;
    private Throwable _lastException;
    private Version serverVersion;

    public static ExecutionContext $lessinit$greater$default$4() {
        return MySQLConnection$.MODULE$.$lessinit$greater$default$4();
    }

    public static EventLoopGroup $lessinit$greater$default$3() {
        return MySQLConnection$.MODULE$.$lessinit$greater$default$3();
    }

    public static CharsetMapper $lessinit$greater$default$2() {
        return MySQLConnection$.MODULE$.$lessinit$greater$default$2();
    }

    public static Logger log() {
        return MySQLConnection$.MODULE$.log();
    }

    public static Version MicrosecondsVersion() {
        return MySQLConnection$.MODULE$.MicrosecondsVersion();
    }

    public static AtomicLong Counter() {
        return MySQLConnection$.MODULE$.Counter();
    }

    public <A> Future<A> inTransaction(Function1<Connection, Future<A>> f, ExecutionContext executionContext) {
        return Connection.class.inTransaction((Connection)this, f, (ExecutionContext)executionContext);
    }

    public Seq<Object> sendPreparedStatement$default$2() {
        return Connection.class.sendPreparedStatement$default$2((Connection)this);
    }

    private final long connectionCount() {
        return this.connectionCount;
    }

    private final String connectionId() {
        return this.connectionId;
    }

    public ExecutionContext com$github$mauricio$async$db$mysql$MySQLConnection$$internalPool() {
        return this.com$github$mauricio$async$db$mysql$MySQLConnection$$internalPool;
    }

    public final MySQLConnectionHandler com$github$mauricio$async$db$mysql$MySQLConnection$$connectionHandler() {
        return this.com$github$mauricio$async$db$mysql$MySQLConnection$$connectionHandler;
    }

    public final Promise<Connection> com$github$mauricio$async$db$mysql$MySQLConnection$$connectionPromise() {
        return this.com$github$mauricio$async$db$mysql$MySQLConnection$$connectionPromise;
    }

    public final Promise<Connection> com$github$mauricio$async$db$mysql$MySQLConnection$$disconnectionPromise() {
        return this.com$github$mauricio$async$db$mysql$MySQLConnection$$disconnectionPromise;
    }

    private AtomicReference<Option<Promise<QueryResult>>> queryPromiseReference() {
        return this.queryPromiseReference;
    }

    private boolean connected() {
        return this.connected;
    }

    private void connected_$eq(boolean x$1) {
        this.connected = x$1;
    }

    private Throwable _lastException() {
        return this._lastException;
    }

    private void _lastException_$eq(Throwable x$1) {
        this._lastException = x$1;
    }

    private Version serverVersion() {
        return this.serverVersion;
    }

    private void serverVersion_$eq(Version x$1) {
        this.serverVersion = x$1;
    }

    public Version version() {
        return this.serverVersion();
    }

    public Throwable lastException() {
        return this._lastException();
    }

    public long count() {
        return this.connectionCount();
    }

    public Future<Connection> connect() {
        this.com$github$mauricio$async$db$mysql$MySQLConnection$$connectionHandler().connect().onFailure((PartialFunction)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MySQLConnection $outer;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                Boolean bl = BoxesRunTime.boxToBoolean((boolean)this.$outer.com$github$mauricio$async$db$mysql$MySQLConnection$$connectionPromise().tryFailure(A1));
                return (B1)bl;
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                boolean bl = true;
                return bl;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, this.com$github$mauricio$async$db$mysql$MySQLConnection$$internalPool());
        return this.com$github$mauricio$async$db$mysql$MySQLConnection$$connectionPromise().future();
    }

    public Future<Connection> close() {
        if (this.isConnected() && !this.com$github$mauricio$async$db$mysql$MySQLConnection$$disconnectionPromise().isCompleted()) {
            DatabaseException exception = new DatabaseException("Connection is being closed");
            exception.fillInStackTrace();
            this.failQueryPromise((Throwable)exception);
            this.com$github$mauricio$async$db$mysql$MySQLConnection$$connectionHandler().clearQueryState();
            ChannelFutureTransformer$.MODULE$.toFuture(this.com$github$mauricio$async$db$mysql$MySQLConnection$$connectionHandler().write(QuitMessage$.MODULE$.Instance())).onComplete((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ MySQLConnection $outer;

                public final Object apply(Try<ChannelFuture> x0$1) {
                    Try<ChannelFuture> try_;
                    block4: {
                        Object object;
                        block3: {
                            block2: {
                                try_ = x0$1;
                                if (!(try_ instanceof Success)) break block2;
                                ChannelFutureTransformer$.MODULE$.toFuture(this.$outer.com$github$mauricio$async$db$mysql$MySQLConnection$$connectionHandler().disconnect()).onComplete((Function1)new Serializable(this){
                                    public static final long serialVersionUID = 0L;
                                    private final /* synthetic */ $anonfun$close$1 $outer;

                                    public final boolean apply(Try<ChannelFuture> x0$2) {
                                        Try<ChannelFuture> try_;
                                        block4: {
                                            boolean bl;
                                            block3: {
                                                block2: {
                                                    try_ = x0$2;
                                                    if (!(try_ instanceof Success)) break block2;
                                                    bl = this.$outer.com$github$mauricio$async$db$mysql$MySQLConnection$$anonfun$$$outer().com$github$mauricio$async$db$mysql$MySQLConnection$$disconnectionPromise().trySuccess((Object)this.$outer.com$github$mauricio$async$db$mysql$MySQLConnection$$anonfun$$$outer());
                                                    break block3;
                                                }
                                                if (!(try_ instanceof Failure)) break block4;
                                                Failure failure = (Failure)try_;
                                                Throwable e = failure.exception();
                                                bl = this.$outer.com$github$mauricio$async$db$mysql$MySQLConnection$$anonfun$$$outer().com$github$mauricio$async$db$mysql$MySQLConnection$$disconnectionPromise().tryFailure(e);
                                            }
                                            return bl;
                                        }
                                        throw new MatchError(try_);
                                    }
                                    {
                                        if ($outer == null) {
                                            throw new NullPointerException();
                                        }
                                        this.$outer = $outer;
                                    }
                                }, this.$outer.com$github$mauricio$async$db$mysql$MySQLConnection$$internalPool());
                                object = BoxedUnit.UNIT;
                                break block3;
                            }
                            if (!(try_ instanceof Failure)) break block4;
                            Failure failure = (Failure)try_;
                            Throwable exception = failure.exception();
                            object = BoxesRunTime.boxToBoolean((boolean)this.$outer.com$github$mauricio$async$db$mysql$MySQLConnection$$disconnectionPromise().tryFailure(exception));
                        }
                        return object;
                    }
                    throw new MatchError(try_);
                }

                public /* synthetic */ MySQLConnection com$github$mauricio$async$db$mysql$MySQLConnection$$anonfun$$$outer() {
                    return this.$outer;
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            }, this.com$github$mauricio$async$db$mysql$MySQLConnection$$internalPool());
        }
        return this.com$github$mauricio$async$db$mysql$MySQLConnection$$disconnectionPromise().future();
    }

    @Override
    public void connected(ChannelHandlerContext ctx) {
        MySQLConnection$.MODULE$.log().debug("Connected to {}", new Object[]{ctx.channel().remoteAddress()});
        this.connected_$eq(true);
    }

    @Override
    public void exceptionCaught(Throwable throwable) {
        MySQLConnection$.MODULE$.log().error("Transport failure ", throwable);
        this.setException(throwable);
    }

    @Override
    public void onError(ErrorMessage message) {
        MySQLConnection$.MODULE$.log().error("Received an error message -> {}", new Object[]{message});
        MySQLException exception = new MySQLException(message);
        exception.fillInStackTrace();
        this.setException((Throwable)((Object)exception));
    }

    private void setException(Throwable t) {
        this._lastException_$eq(t);
        this.com$github$mauricio$async$db$mysql$MySQLConnection$$connectionPromise().tryFailure(t);
        this.failQueryPromise(t);
    }

    @Override
    public void onOk(OkMessage message) {
        if (this.com$github$mauricio$async$db$mysql$MySQLConnection$$connectionPromise().isCompleted()) {
            if (this.isQuerying()) {
                this.succeedQueryPromise(new MySQLQueryResult(message.affectedRows(), message.message(), message.lastInsertId(), message.statusFlags(), message.warnings(), MySQLQueryResult$.MODULE$.$lessinit$greater$default$6()));
            } else {
                MySQLConnection$.MODULE$.log().warn("Received OK when not querying or connecting, not sure what this is");
            }
        } else {
            MySQLConnection$.MODULE$.log().debug("Connected to database");
            this.com$github$mauricio$async$db$mysql$MySQLConnection$$connectionPromise().success((Object)this);
        }
    }

    @Override
    public void onEOF(EOFMessage message) {
        if (this.isQuerying()) {
            this.succeedQueryPromise(new MySQLQueryResult(0L, null, -1L, message.flags(), message.warningCount(), MySQLQueryResult$.MODULE$.$lessinit$greater$default$6()));
        }
    }

    @Override
    public void onHandshake(HandshakeMessage message) {
        this.serverVersion_$eq(Version$.MODULE$.apply(message.serverVersion()));
        String x$4 = this.com$github$mauricio$async$db$mysql$MySQLConnection$$configuration.username();
        Charset x$5 = this.com$github$mauricio$async$db$mysql$MySQLConnection$$configuration.charset();
        byte[] x$6 = message.seed();
        String x$7 = message.authenticationMethod();
        Option x$8 = this.com$github$mauricio$async$db$mysql$MySQLConnection$$configuration.database();
        Option x$9 = this.com$github$mauricio$async$db$mysql$MySQLConnection$$configuration.password();
        this.com$github$mauricio$async$db$mysql$MySQLConnection$$connectionHandler().write(new HandshakeResponseMessage(x$4, x$5, x$6, x$7, (Option<String>)x$9, (Option<String>)x$8));
    }

    @Override
    public void switchAuthentication(AuthenticationSwitchRequest message) {
        this.com$github$mauricio$async$db$mysql$MySQLConnection$$connectionHandler().write(new AuthenticationSwitchResponse((Option<String>)this.com$github$mauricio$async$db$mysql$MySQLConnection$$configuration.password(), message));
    }

    public Future<QueryResult> sendQuery(String query) {
        this.validateIsReadyForQuery();
        Promise promise = Promise$.MODULE$.apply();
        this.setQueryPromise((Promise<QueryResult>)promise);
        this.com$github$mauricio$async$db$mysql$MySQLConnection$$connectionHandler().write(new QueryMessage(query));
        this.addTimeout((Promise<QueryResult>)promise);
        return promise.future();
    }

    private void addTimeout(Promise<QueryResult> promise) {
        this.com$github$mauricio$async$db$mysql$MySQLConnection$$connectionHandler().schedule((Function0<BoxedUnit>)new Serializable(this, promise){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MySQLConnection $outer;
            private final Promise promise$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.promise$1.tryFailure((Throwable)new TimeoutException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"response took too long to return(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.com$github$mauricio$async$db$mysql$MySQLConnection$$configuration.requestTimeout()}))));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.promise$1 = promise$1;
            }
        }, this.com$github$mauricio$async$db$mysql$MySQLConnection$$configuration.requestTimeout());
    }

    private void failQueryPromise(Throwable t) {
        this.clearQueryPromise().foreach((Function1)new Serializable(this, t){
            public static final long serialVersionUID = 0L;
            private final Throwable t$1;

            public final boolean apply(Promise<QueryResult> x$1) {
                return x$1.tryFailure(this.t$1);
            }
            {
                this.t$1 = t$1;
            }
        });
    }

    private void succeedQueryPromise(QueryResult queryResult) {
        this.clearQueryPromise().foreach((Function1)new Serializable(this, queryResult){
            public static final long serialVersionUID = 0L;
            private final QueryResult queryResult$1;

            public final Promise<QueryResult> apply(Promise<QueryResult> x$2) {
                return x$2.success((Object)this.queryResult$1);
            }
            {
                this.queryResult$1 = queryResult$1;
            }
        });
    }

    public boolean isQuerying() {
        return this.queryPromise().isDefined();
    }

    @Override
    public void onResultSet(ResultSet resultSet, EOFMessage message) {
        if (this.isQuerying()) {
            this.succeedQueryPromise(new MySQLQueryResult(resultSet.size(), null, -1L, message.flags(), message.warningCount(), (Option<ResultSet>)new Some((Object)resultSet)));
        }
    }

    public Future<Connection> disconnect() {
        return this.close();
    }

    public boolean isConnected() {
        return this.com$github$mauricio$async$db$mysql$MySQLConnection$$connectionHandler().isConnected();
    }

    public Future<QueryResult> sendPreparedStatement(String query, Seq<Object> values) {
        this.validateIsReadyForQuery();
        int totalParameters = new StringOps(Predef$.MODULE$.augmentString(query)).count((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(char x$3) {
                return x$3 == '?';
            }
        });
        if (values.length() != totalParameters) {
            throw new InsufficientParametersException(totalParameters, values);
        }
        Promise promise = Promise$.MODULE$.apply();
        this.setQueryPromise((Promise<QueryResult>)promise);
        this.com$github$mauricio$async$db$mysql$MySQLConnection$$connectionHandler().sendPreparedStatement(query, values);
        this.addTimeout((Promise<QueryResult>)promise);
        return promise.future();
    }

    public String toString() {
        return new StringOps(Predef$.MODULE$.augmentString("%s(%s,%d)")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.getClass().getName(), this.connectionId(), BoxesRunTime.boxToLong((long)this.connectionCount())}));
    }

    private void validateIsReadyForQuery() {
        if (this.isQuerying()) {
            throw new ConnectionStillRunningQueryException(this.connectionCount(), false);
        }
    }

    private Option<Promise<QueryResult>> queryPromise() {
        return this.queryPromiseReference().get();
    }

    private void setQueryPromise(Promise<QueryResult> promise) {
        if (this.queryPromiseReference().compareAndSet((Option<Promise<QueryResult>>)None$.MODULE$, (Option<Promise<QueryResult>>)new Some(promise))) {
            return;
        }
        throw new ConnectionStillRunningQueryException(this.connectionCount(), true);
    }

    private Option<Promise<QueryResult>> clearQueryPromise() {
        return this.queryPromiseReference().getAndSet((Option<Promise<QueryResult>>)None$.MODULE$);
    }

    public MySQLConnection(Configuration configuration, CharsetMapper charsetMapper, EventLoopGroup group, ExecutionContext executionContext) {
        this.com$github$mauricio$async$db$mysql$MySQLConnection$$configuration = configuration;
        Connection.class.$init$((Connection)this);
        charsetMapper.toInt(configuration.charset());
        this.connectionCount = MySQLConnection$.MODULE$.Counter().incrementAndGet();
        this.connectionId = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[mysql-connection-", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.connectionCount())}));
        this.com$github$mauricio$async$db$mysql$MySQLConnection$$internalPool = executionContext;
        this.com$github$mauricio$async$db$mysql$MySQLConnection$$connectionHandler = new MySQLConnectionHandler(configuration, charsetMapper, this, group, executionContext, this.connectionId());
        this.com$github$mauricio$async$db$mysql$MySQLConnection$$connectionPromise = Promise$.MODULE$.apply();
        this.com$github$mauricio$async$db$mysql$MySQLConnection$$disconnectionPromise = Promise$.MODULE$.apply();
        this.queryPromiseReference = new AtomicReference<None$>(None$.MODULE$);
        this.connected = false;
        this._lastException = null;
        this.serverVersion = null;
    }
}

