/*
 * Decompiled with CFR 0.152.
 */
package com.github.mauricio.async.db.postgresql;

import com.github.mauricio.async.db.Configuration;
import com.github.mauricio.async.db.Connection;
import com.github.mauricio.async.db.QueryResult;
import com.github.mauricio.async.db.column.ColumnDecoderRegistry;
import com.github.mauricio.async.db.column.ColumnEncoderRegistry;
import com.github.mauricio.async.db.exceptions.ConnectionStillRunningQueryException;
import com.github.mauricio.async.db.exceptions.InsufficientParametersException;
import com.github.mauricio.async.db.general.ColumnData;
import com.github.mauricio.async.db.general.MutableResultSet;
import com.github.mauricio.async.db.postgresql.PostgreSQLConnection$;
import com.github.mauricio.async.db.postgresql.PreparedStatementHolder;
import com.github.mauricio.async.db.postgresql.codec.PostgreSQLConnectionDelegate;
import com.github.mauricio.async.db.postgresql.codec.PostgreSQLConnectionHandler;
import com.github.mauricio.async.db.postgresql.exceptions.GenericDatabaseException;
import com.github.mauricio.async.db.postgresql.exceptions.MissingCredentialInformationException;
import com.github.mauricio.async.db.postgresql.exceptions.QueryMustNotBeNullOrEmptyException;
import com.github.mauricio.async.db.postgresql.messages.backend.AuthenticationChallengeCleartextMessage;
import com.github.mauricio.async.db.postgresql.messages.backend.AuthenticationChallengeMD5;
import com.github.mauricio.async.db.postgresql.messages.backend.AuthenticationChallengeMessage;
import com.github.mauricio.async.db.postgresql.messages.backend.AuthenticationMessage;
import com.github.mauricio.async.db.postgresql.messages.backend.AuthenticationOkMessage;
import com.github.mauricio.async.db.postgresql.messages.backend.CommandCompleteMessage;
import com.github.mauricio.async.db.postgresql.messages.backend.DataRowMessage;
import com.github.mauricio.async.db.postgresql.messages.backend.ErrorMessage;
import com.github.mauricio.async.db.postgresql.messages.backend.NotificationResponse;
import com.github.mauricio.async.db.postgresql.messages.backend.ParameterStatusMessage;
import com.github.mauricio.async.db.postgresql.messages.backend.PostgreSQLColumnData;
import com.github.mauricio.async.db.postgresql.messages.backend.RowDescriptionMessage;
import com.github.mauricio.async.db.postgresql.messages.frontend.ClientMessage;
import com.github.mauricio.async.db.postgresql.messages.frontend.CredentialMessage;
import com.github.mauricio.async.db.postgresql.messages.frontend.PreparedStatementExecuteMessage;
import com.github.mauricio.async.db.postgresql.messages.frontend.PreparedStatementMessage;
import com.github.mauricio.async.db.postgresql.messages.frontend.PreparedStatementOpeningMessage;
import com.github.mauricio.async.db.postgresql.messages.frontend.QueryMessage;
import com.github.mauricio.async.db.util.Version;
import com.github.mauricio.async.db.util.Version$;
import io.netty.channel.EventLoopGroup;
import java.util.Iterator;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.IndexedSeq;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.HashMap;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

@ScalaSignature(bytes="\u0006\u0001\u0011-r!B\u0001\u0003\u0011\u0003y\u0011\u0001\u0006)pgR<'/Z*R\u0019\u000e{gN\\3di&|gN\u0003\u0002\u0004\t\u0005Q\u0001o\\:uOJ,7/\u001d7\u000b\u0005\u00151\u0011A\u00013c\u0015\t9\u0001\"A\u0003bgft7M\u0003\u0002\n\u0015\u0005AQ.Y;sS\u000eLwN\u0003\u0002\f\u0019\u00051q-\u001b;ik\nT\u0011!D\u0001\u0004G>l7\u0001\u0001\t\u0003!Ei\u0011A\u0001\u0004\u0006%\tA\ta\u0005\u0002\u0015!>\u001cHo\u001a:f'Fc5i\u001c8oK\u000e$\u0018n\u001c8\u0014\u0005E!\u0002CA\u000b\u0019\u001b\u00051\"\"A\f\u0002\u000bM\u001c\u0017\r\\1\n\u0005e1\"AB!osJ+g\rC\u0003\u001c#\u0011\u0005A$\u0001\u0004=S:LGO\u0010\u000b\u0002\u001f!9a$\u0005b\u0001\n\u000by\u0012aB\"pk:$XM]\u000b\u0002AA\u0011\u0011EK\u0007\u0002E)\u00111\u0005J\u0001\u0007CR|W.[2\u000b\u0005\u00152\u0013AC2p]\u000e,(O]3oi*\u0011q\u0005K\u0001\u0005kRLGNC\u0001*\u0003\u0011Q\u0017M^1\n\u0005-\u0012#AC!u_6L7\rT8oO\"1Q&\u0005Q\u0001\u000e\u0001\n\u0001bQ8v]R,'\u000f\t\u0005\b_E\u0011\r\u0011\"\u00021\u0003A\u0019VM\u001d<feZ+'o]5p].+\u00170F\u00012\u001f\u0005\u0011\u0014%A\u001a\u0002\u001dM,'O^3s?Z,'o]5p]\"1Q'\u0005Q\u0001\u000eE\n\u0011cU3sm\u0016\u0014h+\u001a:tS>t7*Z=!\u0011\u001d9\u0014C1A\u0005\u0006a\n1\u0001\\8h+\u0005I\u0004C\u0001\u001e@\u001b\u0005Y$B\u0001\u001f>\u0003\u0015\u0019HN\u001a\u001bk\u0015\u0005q\u0014aA8sO&\u0011\u0001i\u000f\u0002\u0007\u0019><w-\u001a:\t\r\t\u000b\u0002\u0015!\u0004:\u0003\u0011awn\u001a\u0011\t\u000f\u0011\u000b\u0012\u0013!C\u0001\u000b\u0006YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIE*\u0012A\u0012\u0016\u0003\u000f.\u0003\"\u0001S%\u000e\u0003\u0011I!A\u0013\u0003\u0003\u001b\r{gNZ5hkJ\fG/[8oW\u0005a\u0005CA'S\u001b\u0005q%BA(Q\u0003%)hn\u00195fG.,GM\u0003\u0002R-\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\u0005Ms%!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\"9Q+EI\u0001\n\u00031\u0016a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$#'F\u0001XU\tA6\n\u0005\u0002Z96\t!L\u0003\u0002\\\t\u000511m\u001c7v[:L!!\u0018.\u0003+\r{G.^7o\u000b:\u001cw\u000eZ3s%\u0016<\u0017n\u001d;ss\"9q,EI\u0001\n\u0003\u0001\u0017a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$3'F\u0001bU\t\u00117\n\u0005\u0002ZG&\u0011AM\u0017\u0002\u0016\u0007>dW/\u001c8EK\u000e|G-\u001a:SK\u001eL7\u000f\u001e:z\u0011\u001d1\u0017#%A\u0005\u0002\u001d\f1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\"T#\u00015+\u0005%\\\u0005C\u00016r\u001b\u0005Y'B\u00017n\u0003\u001d\u0019\u0007.\u00198oK2T!A\\8\u0002\u000b9,G\u000f^=\u000b\u0003A\f!![8\n\u0005I\\'AD#wK:$Hj\\8q\u000fJ|W\u000f\u001d\u0005\biF\t\n\u0011\"\u0001v\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%kU\taO\u000b\u0002x\u0017B\u0011\u0001P_\u0007\u0002s*\u0011QEF\u0005\u0003wf\u0014\u0001#\u0012=fGV$\u0018n\u001c8D_:$X\r\u001f;\u0007\tI\u0011\u0001!`\n\u0006yRq\u0018\u0011\u0002\t\u0004\u007f\u0006\u0015QBAA\u0001\u0015\r\t\u0019AA\u0001\u0006G>$WmY\u0005\u0005\u0003\u000f\t\tA\u0001\u000fQ_N$xM]3T#2\u001buN\u001c8fGRLwN\u001c#fY\u0016<\u0017\r^3\u0011\u0007!\u000bY!C\u0002\u0002\u000e\u0011\u0011!bQ8o]\u0016\u001cG/[8o\u0011%\t\t\u0002 B\u0001B\u0003%q)A\u0007d_:4\u0017nZ;sCRLwN\u001c\u0005\n\u0003+a(\u0011!Q\u0001\na\u000bq\"\u001a8d_\u0012,'OU3hSN$(/\u001f\u0005\n\u00033a(\u0011!Q\u0001\n\t\fq\u0002Z3d_\u0012,'OU3hSN$(/\u001f\u0005\n\u0003;a(\u0011!Q\u0001\n%\fQa\u001a:pkBD\u0011\"!\t}\u0005\u0003\u0005\u000b\u0011B<\u0002!\u0015DXmY;uS>t7i\u001c8uKb$\bBB\u000e}\t\u0003\t)\u0003\u0006\u0007\u0002(\u0005%\u00121FA\u0017\u0003_\t\t\u0004\u0005\u0002\u0011y\"I\u0011\u0011CA\u0012!\u0003\u0005\ra\u0012\u0005\n\u0003+\t\u0019\u0003%AA\u0002aC\u0011\"!\u0007\u0002$A\u0005\t\u0019\u00012\t\u0013\u0005u\u00111\u0005I\u0001\u0002\u0004I\u0007\"CA\u0011\u0003G\u0001\n\u00111\u0001x\u0011%\t)\u0004 b\u0001\n\u001b\t9$A\td_:tWm\u0019;j_:D\u0015M\u001c3mKJ,\"!!\u000f\u0011\u0007}\fY$\u0003\u0003\u0002>\u0005\u0005!a\u0007)pgR<'/Z*R\u0019\u000e{gN\\3di&|g\u000eS1oI2,'\u000f\u0003\u0005\u0002Bq\u0004\u000bQBA\u001d\u0003I\u0019wN\u001c8fGRLwN\u001c%b]\u0012dWM\u001d\u0011\t\u0013\u0005\u0015CP1A\u0005\u000e\u0005\u001d\u0013\u0001D2veJ,g\u000e^\"pk:$XCAA%!\r)\u00121J\u0005\u0004\u0003\u001b2\"\u0001\u0002'p]\u001eD\u0001\"!\u0015}A\u00035\u0011\u0011J\u0001\u000eGV\u0014(/\u001a8u\u0007>,h\u000e\u001e\u0011\t\u0013\u0005UCP1A\u0005\u000e\u0005]\u0013!\u00079sKB\f'/\u001a3Ti\u0006$X-\\3oiN\u001cu.\u001e8uKJ,\"!!\u0017\u0011\u0007\u0005\nY&C\u0002\u0002^\t\u0012Q\"\u0011;p[&\u001c\u0017J\u001c;fO\u0016\u0014\b\u0002CA1y\u0002\u0006i!!\u0017\u00025A\u0014X\r]1sK\u0012\u001cF/\u0019;f[\u0016tGo]\"pk:$XM\u001d\u0011\t\u0013\u0005\u0015DP1A\u0005\u0010\u0005\u001d\u0014\u0001G5oi\u0016\u0014h.\u00197Fq\u0016\u001cW\u000f^5p]\u000e{g\u000e^3yiV\tq\u000fC\u0004\u0002lq\u0004\u000bQB<\u00023%tG/\u001a:oC2,\u00050Z2vi&|gnQ8oi\u0016DH\u000f\t\u0005\n\u0003_b(\u0019!C\u0005\u0003c\nq\u0002]1sC6,G/\u001a:Ti\u0006$Xo]\u000b\u0003\u0003g\u0002\u0002\"!\u001e\u0002\u0000\u0005\r\u00151Q\u0007\u0003\u0003oRA!!\u001f\u0002|\u00059Q.\u001e;bE2,'bAA?-\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005\u0005\u0015q\u000f\u0002\b\u0011\u0006\u001c\b.T1q!\u0011\t))a#\u000f\u0007U\t9)C\u0002\u0002\nZ\ta\u0001\u0015:fI\u00164\u0017\u0002BAG\u0003\u001f\u0013aa\u0015;sS:<'bAAE-!A\u00111\u0013?!\u0002\u0013\t\u0019(\u0001\tqCJ\fW.\u001a;feN#\u0018\r^;tA!I\u0011q\u0013?C\u0002\u0013%\u0011\u0011T\u0001\u0011a\u0006\u00148/\u001a3Ti\u0006$X-\\3oiN,\"!a'\u0011\u0011\u0005U\u0014qPAB\u0003;\u00032\u0001EAP\u0013\r\t\tK\u0001\u0002\u0018!J,\u0007/\u0019:fIN#\u0018\r^3nK:$\bj\u001c7eKJD\u0001\"!*}A\u0003%\u00111T\u0001\u0012a\u0006\u00148/\u001a3Ti\u0006$X-\\3oiN\u0004\u0003\"CAUy\u0002\u0007I\u0011BAV\u00035\tW\u000f\u001e5f]RL7-\u0019;fIV\u0011\u0011Q\u0016\t\u0004+\u0005=\u0016bAAY-\t9!i\\8mK\u0006t\u0007\"CA[y\u0002\u0007I\u0011BA\\\u0003E\tW\u000f\u001e5f]RL7-\u0019;fI~#S-\u001d\u000b\u0005\u0003s\u000by\fE\u0002\u0016\u0003wK1!!0\u0017\u0005\u0011)f.\u001b;\t\u0015\u0005\u0005\u00171WA\u0001\u0002\u0004\ti+A\u0002yIEB\u0001\"!2}A\u0003&\u0011QV\u0001\u000fCV$\b.\u001a8uS\u000e\fG/\u001a3!\u0011%\tI\r b\u0001\n\u0013\tY-\u0001\td_:tWm\u0019;j_:4U\u000f^;sKV\u0011\u0011Q\u001a\t\u0006q\u0006=\u0017\u0011B\u0005\u0004\u0003#L(a\u0002)s_6L7/\u001a\u0005\t\u0003+d\b\u0015!\u0003\u0002N\u0006\t2m\u001c8oK\u000e$\u0018n\u001c8GkR,(/\u001a\u0011\t\u0013\u0005eG\u00101A\u0005\n\u0005-\u0016a\u0003:fG\u0016tG/\u0012:s_JD\u0011\"!8}\u0001\u0004%I!a8\u0002\u001fI,7-\u001a8u\u000bJ\u0014xN]0%KF$B!!/\u0002b\"Q\u0011\u0011YAn\u0003\u0003\u0005\r!!,\t\u0011\u0005\u0015H\u0010)Q\u0005\u0003[\u000bAB]3dK:$XI\u001d:pe\u0002B\u0011\"!;}\u0005\u0004%I!a;\u0002+E,XM]=Qe>l\u0017n]3SK\u001a,'/\u001a8dKV\u0011\u0011Q\u001e\t\u0006C\u0005=\u00181_\u0005\u0004\u0003c\u0014#aD!u_6L7MU3gKJ,gnY3\u0011\u000bU\t)0!?\n\u0007\u0005]hC\u0001\u0004PaRLwN\u001c\t\u0006q\u0006=\u00171 \t\u0004\u0011\u0006u\u0018bAA\u0000\t\tY\u0011+^3ssJ+7/\u001e7u\u0011!\u0011\u0019\u0001 Q\u0001\n\u00055\u0018AF9vKJL\bK]8nSN,'+\u001a4fe\u0016t7-\u001a\u0011\t\u0013\t\u001dA\u00101A\u0005\n\t%\u0011\u0001D2veJ,g\u000e^)vKJLXC\u0001B\u0006!\u0015)\u0012Q\u001fB\u0007!\u0019\u0011yA!\u0006\u0003\u001a5\u0011!\u0011\u0003\u0006\u0004\u0005'!\u0011aB4f]\u0016\u0014\u0018\r\\\u0005\u0005\u0005/\u0011\tB\u0001\tNkR\f'\r\\3SKN,H\u000e^*fiB!!1\u0004B\u0013\u001b\t\u0011iB\u0003\u0003\u0003 \t\u0005\u0012a\u00022bG.,g\u000e\u001a\u0006\u0004\u0005G\u0011\u0011\u0001C7fgN\fw-Z:\n\t\t\u001d\"Q\u0004\u0002\u0015!>\u001cHo\u001a:f'Fc5i\u001c7v[:$\u0015\r^1\t\u0013\t-B\u00101A\u0005\n\t5\u0012\u0001E2veJ,g\u000e^)vKJLx\fJ3r)\u0011\tILa\f\t\u0015\u0005\u0005'\u0011FA\u0001\u0002\u0004\u0011Y\u0001\u0003\u0005\u00034q\u0004\u000b\u0015\u0002B\u0006\u00035\u0019WO\u001d:f]R\fV/\u001a:zA!I!q\u0007?A\u0002\u0013%!\u0011H\u0001\u0019GV\u0014(/\u001a8u!J,\u0007/\u0019:fIN#\u0018\r^3nK:$XC\u0001B\u001e!\u0015)\u0012Q_AO\u0011%\u0011y\u0004 a\u0001\n\u0013\u0011\t%\u0001\u000fdkJ\u0014XM\u001c;Qe\u0016\u0004\u0018M]3e'R\fG/Z7f]R|F%Z9\u0015\t\u0005e&1\t\u0005\u000b\u0003\u0003\u0014i$!AA\u0002\tm\u0002\u0002\u0003B$y\u0002\u0006KAa\u000f\u00023\r,(O]3oiB\u0013X\r]1sK\u0012\u001cF/\u0019;f[\u0016tG\u000f\t\u0005\n\u0005\u0017b\b\u0019!C\u0005\u0005\u001b\nqA^3sg&|g.\u0006\u0002\u0003PA!!\u0011\u000bB+\u001b\t\u0011\u0019F\u0003\u0002(\t%!!q\u000bB*\u0005\u001d1VM]:j_:D\u0011Ba\u0017}\u0001\u0004%IA!\u0018\u0002\u0017Y,'o]5p]~#S-\u001d\u000b\u0005\u0003s\u0013y\u0006\u0003\u0006\u0002B\ne\u0013\u0011!a\u0001\u0005\u001fB\u0001Ba\u0019}A\u0003&!qJ\u0001\tm\u0016\u00148/[8oA!I!q\r?A\u0002\u0013%!\u0011N\u0001\u0010]>$\u0018NZ=MSN$XM\\3sgV\u0011!1\u000e\t\u0007\u0005[\u0012yGa\u001d\u000e\u0003\u0011J1A!\u001d%\u0005Q\u0019u\u000e]=P]^\u0013\u0018\u000e^3BeJ\f\u0017\u0010T5tiB9QC!\u001e\u0003z\u0005e\u0016b\u0001B<-\tIa)\u001e8di&|g.\r\t\u0005\u00057\u0011Y(\u0003\u0003\u0003~\tu!\u0001\u0006(pi&4\u0017nY1uS>t'+Z:q_:\u001cX\rC\u0005\u0003\u0002r\u0004\r\u0011\"\u0003\u0003\u0004\u0006\u0019bn\u001c;jMfd\u0015n\u001d;f]\u0016\u00148o\u0018\u0013fcR!\u0011\u0011\u0018BC\u0011)\t\tMa \u0002\u0002\u0003\u0007!1\u000e\u0005\t\u0005\u0013c\b\u0015)\u0003\u0003l\u0005\u0001bn\u001c;jMfd\u0015n\u001d;f]\u0016\u00148\u000f\t\u0005\n\u0005\u001bc\b\u0019!C\u0005\u0005\u001f\u000b1\"];fef\u0014Vm];miV\u0011!\u0011\u0013\t\u0006+\u0005U\u00181 \u0005\n\u0005+c\b\u0019!C\u0005\u0005/\u000bq\"];fef\u0014Vm];mi~#S-\u001d\u000b\u0005\u0003s\u0013I\n\u0003\u0006\u0002B\nM\u0015\u0011!a\u0001\u0005#C\u0001B!(}A\u0003&!\u0011S\u0001\rcV,'/\u001f*fgVdG\u000f\t\u0005\b\u0005CcH\u0011AAV\u0003=I7OU3bIf4uN])vKJL\bb\u0002BSy\u0012\u0005!qU\u0001\bG>tg.Z2u+\t\u0011I\u000bE\u0003y\u0005W\u000bI!C\u0002\u0003.f\u0014aAR;ukJ,\u0007b\u0002BYy\u0012\u0005#qU\u0001\u000bI&\u001c8m\u001c8oK\u000e$\bb\u0002B[y\u0012\u0005\u00131V\u0001\fSN\u001cuN\u001c8fGR,G\rC\u0004\u0003:r$\tAa/\u0002#A\f'/Y7fi\u0016\u00148\u000b^1ukN,7/\u0006\u0002\u0003>BA!q\u0018Bc\u0003\u0007\u000b\u0019)\u0004\u0002\u0003B*!!1YA>\u0003%IW.\\;uC\ndW-\u0003\u0003\u0003H\n\u0005'aA'ba\"9!1\u001a?\u0005B\t5\u0017!C:f]\u0012\fV/\u001a:z)\u0011\u0011yM!5\u0011\u000ba\u0014Y+a?\t\u0011\tM'\u0011\u001aa\u0001\u0003\u0007\u000bQ!];fefDqAa6}\t\u0003\u0012I.A\u000btK:$\u0007K]3qCJ,Gm\u0015;bi\u0016lWM\u001c;\u0015\r\t='1\u001cBo\u0011!\u0011\u0019N!6A\u0002\u0005\r\u0005B\u0003Bp\u0005+\u0004\n\u00111\u0001\u0003b\u00061a/\u00197vKN\u0004bAa9\u0003t\neh\u0002\u0002Bs\u0005_tAAa:\u0003n6\u0011!\u0011\u001e\u0006\u0004\u0005Wt\u0011A\u0002\u001fs_>$h(C\u0001\u0018\u0013\r\u0011\tPF\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\u0011)Pa>\u0003\u0007M+\u0017OC\u0002\u0003rZ\u00012!\u0006B~\u0013\r\u0011iP\u0006\u0002\u0004\u0003:L\bbBB\u0001y\u0012\u000531A\u0001\b_:,%O]8s)\u0011\tIl!\u0002\t\u0011\r\u001d!q a\u0001\u0007\u0013\t\u0011\"\u001a=dKB$\u0018n\u001c8\u0011\t\t\r81B\u0005\u0005\u0007\u001b\u00119PA\u0005UQJ|w/\u00192mK\"91\u0011\u0003?\u0005\u0002\u0005-\u0016A\u00045bgJ+7-\u001a8u\u000bJ\u0014xN\u001d\u0005\b\u0007+aH\u0011BB\f\u0003E\u0019X\r^#se>\u0014xJ\u001c$viV\u0014Xm\u001d\u000b\u0005\u0003s\u001bI\u0002\u0003\u0005\u0004\u001c\rM\u0001\u0019AB\u0005\u0003\u0005)\u0007bBB\u0010y\u0012\u00053\u0011E\u0001\u0010_:\u0014V-\u00193z\r>\u0014\u0018+^3ssR\u0011\u0011\u0011\u0018\u0005\b\u0007\u0003aH\u0011IB\u0013)\u0011\tIla\n\t\u0011\r%21\u0005a\u0001\u0007W\t\u0011!\u001c\t\u0005\u00057\u0019i#\u0003\u0003\u00040\tu!\u0001D#se>\u0014X*Z:tC\u001e,\u0007bBB\u001ay\u0012\u00053QG\u0001\u0012_:\u001cu.\\7b]\u0012\u001cu.\u001c9mKR,G\u0003BA]\u0007oA\u0001b!\u000b\u00042\u0001\u00071\u0011\b\t\u0005\u00057\u0019Y$\u0003\u0003\u0004>\tu!AF\"p[6\fg\u000eZ\"p[BdW\r^3NKN\u001c\u0018mZ3\t\u000f\r\u0005C\u0010\"\u0011\u0004D\u0005\trN\u001c)be\u0006lW\r^3s'R\fG/^:\u0015\t\u0005e6Q\t\u0005\t\u0007S\u0019y\u00041\u0001\u0004HA!!1DB%\u0013\u0011\u0019YE!\b\u0003-A\u000b'/Y7fi\u0016\u00148\u000b^1ukNlUm]:bO\u0016Dqaa\u0014}\t\u0003\u001a\t&A\u0005p]\u0012\u000bG/\u0019*poR!\u0011\u0011XB*\u0011!\u0019Ic!\u0014A\u0002\rU\u0003\u0003\u0002B\u000e\u0007/JAa!\u0017\u0003\u001e\tqA)\u0019;b%><X*Z:tC\u001e,\u0007bBB/y\u0012\u00053qL\u0001\u0011_:\u0014vn\u001e#fg\u000e\u0014\u0018\u000e\u001d;j_:$B!!/\u0004b!A1\u0011FB.\u0001\u0004\u0019\u0019\u0007\u0005\u0003\u0003\u001c\r\u0015\u0014\u0002BB4\u0005;\u0011QCU8x\t\u0016\u001c8M]5qi&|g.T3tg\u0006<W\rC\u0004\u0004lq$Ia!\u001c\u0002\u001dM,GoQ8mk6tG)\u0019;bgR!\u0011\u0011XB8\u0011!\u0019\th!\u001bA\u0002\rM\u0014aC2pYVlg\u000eR1uCN\u0004R!FB;\u00053I1aa\u001e\u0017\u0005\u0015\t%O]1z\u0011\u001d\u0019Y\b C!\u0007{\n\u0001d\u001c8BkRDWM\u001c;jG\u0006$\u0018n\u001c8SKN\u0004xN\\:f)\u0011\tIla \t\u0011\r\u00055\u0011\u0010a\u0001\u0007\u0007\u000bq!\\3tg\u0006<W\r\u0005\u0003\u0003\u001c\r\u0015\u0015\u0002BBD\u0005;\u0011Q#Q;uQ\u0016tG/[2bi&|g.T3tg\u0006<W\rC\u0004\u0004\fr$\te!$\u0002-=tgj\u001c;jM&\u001c\u0017\r^5p]J+7\u000f]8og\u0016$B!!/\u0004\u0010\"A1\u0011QBE\u0001\u0004\u0011I\bC\u0004\u0004\u0014r$\ta!&\u0002-I,w-[:uKJtu\u000e^5gs2K7\u000f^3oKJ$B!!/\u0004\u0018\"A1\u0011TBI\u0001\u0004\u0011\u0019(\u0001\u0005mSN$XM\\3s\u0011\u001d\u0019i\n C\u0001\u0007?\u000b\u0001$\u001e8sK\u001eL7\u000f^3s\u001d>$\u0018NZ=MSN$XM\\3s)\u0011\tIl!)\t\u0011\re51\u0014a\u0001\u0005gBqa!*}\t\u0003\u0019\t#\u0001\u000bdY\u0016\f'OT8uS\u001aLH*[:uK:,'o\u001d\u0005\b\u0007ScH\u0011BBV\u0003)\u0019'/\u001a3f]RL\u0017\r\u001c\u000b\u0005\u0007[\u001bI\f\u0005\u0003\u00040\u000eUVBABY\u0015\u0011\u0019\u0019L!\t\u0002\u0011\u0019\u0014xN\u001c;f]\u0012LAaa.\u00042\n\t2I]3eK:$\u0018.\u00197NKN\u001c\u0018mZ3\t\u0011\rm6q\u0015a\u0001\u0007{\u000bQ#Y;uQ\u0016tG/[2bi&|g.T3tg\u0006<W\r\u0005\u0003\u0003\u001c\r}\u0016\u0002BBa\u0005;\u0011a$Q;uQ\u0016tG/[2bi&|gn\u00115bY2,gnZ3NKN\u001c\u0018mZ3\t\u0011\r\u0015G\u0010)C\u0005\u0007\u000f\fQC\\8u%\u0016\fG-\u001f$peF+XM]=FeJ|'\u000f\u0006\u0004\u0004J\u000e=71\u001b\t\u0004+\r-\u0017bABg-\t9aj\u001c;iS:<\u0007\u0002CBi\u0007\u0007\u0004\r!a!\u0002\u0019\u0015\u0014(o\u001c:NKN\u001c\u0018mZ3\t\u0011\rU71\u0019a\u0001\u0003[\u000bAA]1dK\"91\u0011\u001c?\u0005\u0002\rm\u0017a\u0007<bY&$\u0017\r^3JM&#\u0018j\u001d*fC\u0012Lhi\u001c:Rk\u0016\u0014\u0018\u0010\u0006\u0003\u0002:\u000eu\u0007\u0002CBi\u0007/\u0004\r!a!\t\u000f\r\u0005H\u0010\"\u0003\u0004d\u0006ia/\u00197jI\u0006$X-U;fef$B!!/\u0004f\"A!1[Bp\u0001\u0004\t\u0019\tC\u0004\u0004jr$Iaa;\u0002\u0019E,XM]=Qe>l\u0017n]3\u0016\u0005\u0005M\bbBBxy\u0012%1\u0011_\u0001\u0010g\u0016$\u0018+^3ssB\u0013x.\\5tKR!\u0011\u0011XBz\u0011!\u0019)p!<A\u0002\u0005e\u0018a\u00029s_6L7/\u001a\u0005\b\u0007sdH\u0011BBv\u0003E\u0019G.Z1s#V,'/\u001f)s_6L7/\u001a\u0005\b\u0007{dH\u0011BB\u0000\u0003A1\u0017-\u001b7Rk\u0016\u0014\u0018\u0010\u0015:p[&\u001cX\r\u0006\u0003\u0002:\u0012\u0005\u0001\u0002\u0003C\u0002\u0007w\u0004\ra!\u0003\u0002\u0003QDq\u0001b\u0002}\t\u0013!I!A\ntk\u000e\u001cW-\u001a3Rk\u0016\u0014\u0018\u0010\u0015:p[&\u001cX\r\u0006\u0003\u0002:\u0012-\u0001\u0002\u0003C\u0007\t\u000b\u0001\r!a?\u0002\rI,7/\u001e7u\u0011\u001d!\t\u0002 C\u0005\t'\tQa\u001e:ji\u0016$B!!/\u0005\u0016!A1\u0011\u0011C\b\u0001\u0004!9\u0002\u0005\u0003\u00040\u0012e\u0011\u0002\u0002C\u000e\u0007c\u0013Qb\u00117jK:$X*Z:tC\u001e,\u0007b\u0002C\u0010y\u0012\u0005C\u0011E\u0001\ti>\u001cFO]5oOR\u0011\u00111\u0011\u0005\n\tKa\u0018\u0013!C!\tO\tqd]3oIB\u0013X\r]1sK\u0012\u001cF/\u0019;f[\u0016tG\u000f\n3fM\u0006,H\u000e\u001e\u00133+\t!ICK\u0002\u0003b.\u0003")
public class PostgreSQLConnection
implements PostgreSQLConnectionDelegate,
Connection {
    private final Configuration configuration;
    private final ColumnEncoderRegistry encoderRegistry;
    private final ColumnDecoderRegistry decoderRegistry;
    private final PostgreSQLConnectionHandler connectionHandler;
    private final long currentCount;
    private final AtomicInteger com$github$mauricio$async$db$postgresql$PostgreSQLConnection$$preparedStatementsCounter;
    private final ExecutionContext internalExecutionContext;
    private final HashMap<String, String> parameterStatus;
    private final HashMap<String, PreparedStatementHolder> com$github$mauricio$async$db$postgresql$PostgreSQLConnection$$parsedStatements;
    private boolean authenticated;
    private final Promise<Connection> com$github$mauricio$async$db$postgresql$PostgreSQLConnection$$connectionFuture;
    private boolean recentError;
    private final AtomicReference<Option<Promise<QueryResult>>> queryPromiseReference;
    private Option<MutableResultSet<PostgreSQLColumnData>> currentQuery;
    private Option<PreparedStatementHolder> currentPreparedStatement;
    private Version version;
    private CopyOnWriteArrayList<Function1<NotificationResponse, BoxedUnit>> notifyListeners;
    private Option<QueryResult> queryResult;

    public static ExecutionContext $lessinit$greater$default$5() {
        return PostgreSQLConnection$.MODULE$.$lessinit$greater$default$5();
    }

    public static EventLoopGroup $lessinit$greater$default$4() {
        return PostgreSQLConnection$.MODULE$.$lessinit$greater$default$4();
    }

    public static ColumnDecoderRegistry $lessinit$greater$default$3() {
        return PostgreSQLConnection$.MODULE$.$lessinit$greater$default$3();
    }

    public static ColumnEncoderRegistry $lessinit$greater$default$2() {
        return PostgreSQLConnection$.MODULE$.$lessinit$greater$default$2();
    }

    public static Configuration $lessinit$greater$default$1() {
        return PostgreSQLConnection$.MODULE$.$lessinit$greater$default$1();
    }

    public static Logger log() {
        return PostgreSQLConnection$.MODULE$.log();
    }

    public static String ServerVersionKey() {
        return PostgreSQLConnection$.MODULE$.ServerVersionKey();
    }

    public static AtomicLong Counter() {
        return PostgreSQLConnection$.MODULE$.Counter();
    }

    public <A> Future<A> inTransaction(Function1<Connection, Future<A>> f, ExecutionContext executionContext) {
        return Connection.class.inTransaction((Connection)this, f, (ExecutionContext)executionContext);
    }

    private final PostgreSQLConnectionHandler connectionHandler() {
        return this.connectionHandler;
    }

    private final long currentCount() {
        return this.currentCount;
    }

    public final AtomicInteger com$github$mauricio$async$db$postgresql$PostgreSQLConnection$$preparedStatementsCounter() {
        return this.com$github$mauricio$async$db$postgresql$PostgreSQLConnection$$preparedStatementsCounter;
    }

    private final ExecutionContext internalExecutionContext() {
        return this.internalExecutionContext;
    }

    private HashMap<String, String> parameterStatus() {
        return this.parameterStatus;
    }

    public HashMap<String, PreparedStatementHolder> com$github$mauricio$async$db$postgresql$PostgreSQLConnection$$parsedStatements() {
        return this.com$github$mauricio$async$db$postgresql$PostgreSQLConnection$$parsedStatements;
    }

    private boolean authenticated() {
        return this.authenticated;
    }

    private void authenticated_$eq(boolean x$1) {
        this.authenticated = x$1;
    }

    public Promise<Connection> com$github$mauricio$async$db$postgresql$PostgreSQLConnection$$connectionFuture() {
        return this.com$github$mauricio$async$db$postgresql$PostgreSQLConnection$$connectionFuture;
    }

    private boolean recentError() {
        return this.recentError;
    }

    private void recentError_$eq(boolean x$1) {
        this.recentError = x$1;
    }

    private AtomicReference<Option<Promise<QueryResult>>> queryPromiseReference() {
        return this.queryPromiseReference;
    }

    private Option<MutableResultSet<PostgreSQLColumnData>> currentQuery() {
        return this.currentQuery;
    }

    private void currentQuery_$eq(Option<MutableResultSet<PostgreSQLColumnData>> x$1) {
        this.currentQuery = x$1;
    }

    private Option<PreparedStatementHolder> currentPreparedStatement() {
        return this.currentPreparedStatement;
    }

    private void currentPreparedStatement_$eq(Option<PreparedStatementHolder> x$1) {
        this.currentPreparedStatement = x$1;
    }

    private Version version() {
        return this.version;
    }

    private void version_$eq(Version x$1) {
        this.version = x$1;
    }

    private CopyOnWriteArrayList<Function1<NotificationResponse, BoxedUnit>> notifyListeners() {
        return this.notifyListeners;
    }

    private void notifyListeners_$eq(CopyOnWriteArrayList<Function1<NotificationResponse, BoxedUnit>> x$1) {
        this.notifyListeners = x$1;
    }

    private Option<QueryResult> queryResult() {
        return this.queryResult;
    }

    private void queryResult_$eq(Option<QueryResult> x$1) {
        this.queryResult = x$1;
    }

    public boolean isReadyForQuery() {
        return this.queryPromise().isEmpty();
    }

    public Future<Connection> connect() {
        this.connectionHandler().connect().onFailure((PartialFunction)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PostgreSQLConnection $outer;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                Boolean bl = BoxesRunTime.boxToBoolean((boolean)this.$outer.com$github$mauricio$async$db$postgresql$PostgreSQLConnection$$connectionFuture().tryFailure(A1));
                return (B1)bl;
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                boolean bl = true;
                return bl;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, this.internalExecutionContext());
        return this.com$github$mauricio$async$db$postgresql$PostgreSQLConnection$$connectionFuture().future();
    }

    public Future<Connection> disconnect() {
        return this.connectionHandler().disconnect().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PostgreSQLConnection $outer;

            public final PostgreSQLConnection apply(PostgreSQLConnectionHandler c) {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, this.internalExecutionContext());
    }

    public boolean isConnected() {
        return this.connectionHandler().isConnected();
    }

    public Map<String, String> parameterStatuses() {
        return this.parameterStatus().toMap(Predef$.MODULE$.conforms());
    }

    public Future<QueryResult> sendQuery(String query) {
        this.validateQuery(query);
        Promise promise = Promise$.MODULE$.apply();
        this.setQueryPromise((Promise<QueryResult>)promise);
        this.write(new QueryMessage(query));
        return promise.future();
    }

    public Future<QueryResult> sendPreparedStatement(String query, Seq<Object> values) {
        PreparedStatementMessage preparedStatementMessage;
        this.validateQuery(query);
        Promise promise = Promise$.MODULE$.apply();
        this.setQueryPromise((Promise<QueryResult>)promise);
        PreparedStatementHolder holder = (PreparedStatementHolder)this.com$github$mauricio$async$db$postgresql$PostgreSQLConnection$$parsedStatements().getOrElseUpdate((Object)query, (Function0)new Serializable(this, query){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PostgreSQLConnection $outer;
            private final String query$1;

            public final PreparedStatementHolder apply() {
                return new PreparedStatementHolder(this.query$1, this.$outer.com$github$mauricio$async$db$postgresql$PostgreSQLConnection$$preparedStatementsCounter().incrementAndGet());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.query$1 = query$1;
            }
        });
        if (holder.paramsCount() != values.length()) {
            this.clearQueryPromise();
            throw new InsufficientParametersException(holder.paramsCount(), values);
        }
        this.currentPreparedStatement_$eq((Option<PreparedStatementHolder>)new Some((Object)holder));
        this.currentQuery_$eq((Option<MutableResultSet<PostgreSQLColumnData>>)new Some((Object)new MutableResultSet((IndexedSeq)Predef$.MODULE$.wrapRefArray((Object[])holder.columnDatas()))));
        if (holder.prepared()) {
            preparedStatementMessage = new PreparedStatementExecuteMessage(holder.statementId(), holder.realQuery(), values, this.encoderRegistry);
        } else {
            holder.prepared_$eq(true);
            preparedStatementMessage = new PreparedStatementOpeningMessage(holder.statementId(), holder.realQuery(), values, this.encoderRegistry);
        }
        this.write(preparedStatementMessage);
        return promise.future();
    }

    public Seq<Object> sendPreparedStatement$default$2() {
        return Nil$.MODULE$;
    }

    @Override
    public void onError(Throwable exception) {
        this.setErrorOnFutures(exception);
    }

    public boolean hasRecentError() {
        return this.recentError();
    }

    private void setErrorOnFutures(Throwable e) {
        Future<Connection> future;
        this.recentError_$eq(true);
        PostgreSQLConnection$.MODULE$.log().error("Error on connection", e);
        if (this.com$github$mauricio$async$db$postgresql$PostgreSQLConnection$$connectionFuture().isCompleted()) {
            future = BoxedUnit.UNIT;
        } else {
            this.com$github$mauricio$async$db$postgresql$PostgreSQLConnection$$connectionFuture().failure(e);
            future = this.disconnect();
        }
        this.currentPreparedStatement().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PostgreSQLConnection $outer;

            public final Option<PreparedStatementHolder> apply(PreparedStatementHolder p) {
                return this.$outer.com$github$mauricio$async$db$postgresql$PostgreSQLConnection$$parsedStatements().remove((Object)p.query());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.currentPreparedStatement_$eq((Option<PreparedStatementHolder>)None$.MODULE$);
        this.failQueryPromise(e);
    }

    @Override
    public void onReadyForQuery() {
        this.com$github$mauricio$async$db$postgresql$PostgreSQLConnection$$connectionFuture().trySuccess((Object)this);
        this.recentError_$eq(false);
        this.queryResult().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PostgreSQLConnection $outer;

            public final void apply(QueryResult result) {
                this.$outer.com$github$mauricio$async$db$postgresql$PostgreSQLConnection$$succeedQueryPromise(result);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }

    @Override
    public void onError(ErrorMessage m) {
        PostgreSQLConnection$.MODULE$.log().error("Error with message -> {}", new Object[]{m});
        GenericDatabaseException error = new GenericDatabaseException(m);
        error.fillInStackTrace();
        this.setErrorOnFutures((Throwable)((Object)error));
    }

    @Override
    public void onCommandComplete(CommandCompleteMessage m) {
        this.currentPreparedStatement_$eq((Option<PreparedStatementHolder>)None$.MODULE$);
        this.queryResult_$eq((Option<QueryResult>)new Some((Object)new QueryResult((long)m.rowsAffected(), m.statusMessage(), this.currentQuery())));
    }

    @Override
    public void onParameterStatus(ParameterStatusMessage m) {
        this.parameterStatus().put((Object)m.key(), (Object)m.value());
        String string = m.key();
        if (!("server_version" != null ? !"server_version".equals(string) : string != null)) {
            this.version_$eq(Version$.MODULE$.apply(m.value()));
        }
    }

    @Override
    public void onDataRow(DataRowMessage m) {
        Object[] items = new Object[Predef$.MODULE$.refArrayOps((Object[])m.values()).size()];
        for (int x = 0; x < Predef$.MODULE$.refArrayOps((Object[])m.values()).size(); ++x) {
            Object object;
            if (m.values()[x] == null) {
                object = null;
            } else {
                PostgreSQLColumnData columnType = (PostgreSQLColumnData)((MutableResultSet)this.currentQuery().get()).columnTypes().apply(x);
                object = this.decoderRegistry.decode((ColumnData)columnType, m.values()[x], this.configuration.charset());
            }
            items[x] = object;
        }
        ((MutableResultSet)this.currentQuery().get()).addRow((Seq)Predef$.MODULE$.genericWrapArray((Object)items));
    }

    @Override
    public void onRowDescription(RowDescriptionMessage m) {
        this.currentQuery_$eq((Option<MutableResultSet<PostgreSQLColumnData>>)Option$.MODULE$.apply((Object)new MutableResultSet((IndexedSeq)Predef$.MODULE$.wrapRefArray((Object[])m.columnDatas()))));
        this.setColumnDatas(m.columnDatas());
    }

    private void setColumnDatas(PostgreSQLColumnData[] columnDatas) {
        this.currentPreparedStatement().foreach((Function1)new Serializable(this, columnDatas){
            public static final long serialVersionUID = 0L;
            private final PostgreSQLColumnData[] columnDatas$1;

            public final void apply(PreparedStatementHolder holder) {
                holder.columnDatas_$eq(this.columnDatas$1);
            }
            {
                this.columnDatas$1 = columnDatas$1;
            }
        });
    }

    @Override
    public void onAuthenticationResponse(AuthenticationMessage message) {
        AuthenticationMessage authenticationMessage;
        block5: {
            block3: {
                block4: {
                    block2: {
                        authenticationMessage = message;
                        if (!(authenticationMessage instanceof AuthenticationOkMessage)) break block2;
                        PostgreSQLConnection$.MODULE$.log().debug("Successfully logged in to database");
                        this.authenticated_$eq(true);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        break block3;
                    }
                    if (!(authenticationMessage instanceof AuthenticationChallengeCleartextMessage)) break block4;
                    AuthenticationChallengeCleartextMessage authenticationChallengeCleartextMessage = (AuthenticationChallengeCleartextMessage)authenticationMessage;
                    this.write(this.credential(authenticationChallengeCleartextMessage));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block3;
                }
                if (!(authenticationMessage instanceof AuthenticationChallengeMD5)) break block5;
                AuthenticationChallengeMD5 authenticationChallengeMD5 = (AuthenticationChallengeMD5)authenticationMessage;
                this.write(this.credential(authenticationChallengeMD5));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
        throw new MatchError((Object)authenticationMessage);
    }

    @Override
    public void onNotificationResponse(NotificationResponse message) {
        Iterator<Function1<NotificationResponse, BoxedUnit>> iterator = this.notifyListeners().iterator();
        while (iterator.hasNext()) {
            iterator.next().apply((Object)message);
        }
    }

    public void registerNotifyListener(Function1<NotificationResponse, BoxedUnit> listener) {
        this.notifyListeners().add(listener);
    }

    public void unregisterNotifyListener(Function1<NotificationResponse, BoxedUnit> listener) {
        this.notifyListeners().remove(listener);
    }

    public void clearNotifyListeners() {
        this.notifyListeners().clear();
    }

    private CredentialMessage credential(AuthenticationChallengeMessage authenticationMessage) {
        if (this.configuration.username() != null && this.configuration.password().isDefined()) {
            return new CredentialMessage(this.configuration.username(), (String)this.configuration.password().get(), authenticationMessage.challengeType(), authenticationMessage.salt());
        }
        throw new MissingCredentialInformationException(this.configuration.username(), (Option<String>)this.configuration.password(), authenticationMessage.challengeType());
    }

    private Nothing$ notReadyForQueryError(String errorMessage, boolean race) {
        PostgreSQLConnection$.MODULE$.log().error(errorMessage);
        throw new ConnectionStillRunningQueryException(this.currentCount(), race);
    }

    public void validateIfItIsReadyForQuery(String errorMessage) {
        if (this.queryPromise().isDefined()) {
            throw this.notReadyForQueryError(errorMessage, false);
        }
    }

    private void validateQuery(String query) {
        this.validateIfItIsReadyForQuery("Can't run query because there is one query pending already");
        if (query == null || query.isEmpty()) {
            throw new QueryMustNotBeNullOrEmptyException(query);
        }
    }

    private Option<Promise<QueryResult>> queryPromise() {
        return this.queryPromiseReference().get();
    }

    private void setQueryPromise(Promise<QueryResult> promise) {
        if (this.queryPromiseReference().compareAndSet((Option<Promise<QueryResult>>)None$.MODULE$, (Option<Promise<QueryResult>>)new Some(promise))) {
            return;
        }
        throw this.notReadyForQueryError("Can't run query due to a race with another started query", true);
    }

    private Option<Promise<QueryResult>> clearQueryPromise() {
        return this.queryPromiseReference().getAndSet((Option<Promise<QueryResult>>)None$.MODULE$);
    }

    private void failQueryPromise(Throwable t) {
        this.clearQueryPromise().foreach((Function1)new Serializable(this, t){
            public static final long serialVersionUID = 0L;
            private final Throwable t$1;

            public final Promise<QueryResult> apply(Promise<QueryResult> promise) {
                PostgreSQLConnection$.MODULE$.log().error("Setting error on future {}", new Object[]{promise});
                return promise.failure(this.t$1);
            }
            {
                this.t$1 = t$1;
            }
        });
    }

    public void com$github$mauricio$async$db$postgresql$PostgreSQLConnection$$succeedQueryPromise(QueryResult result) {
        this.queryResult_$eq((Option<QueryResult>)None$.MODULE$);
        this.currentQuery_$eq((Option<MutableResultSet<PostgreSQLColumnData>>)None$.MODULE$);
        this.clearQueryPromise().foreach((Function1)new Serializable(this, result){
            public static final long serialVersionUID = 0L;
            private final QueryResult result$1;

            public final Promise<QueryResult> apply(Promise<QueryResult> x$1) {
                return x$1.success((Object)this.result$1);
            }
            {
                this.result$1 = result$1;
            }
        });
    }

    private void write(ClientMessage message) {
        this.connectionHandler().write(message);
    }

    public String toString() {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "{counter=", "}"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.getClass().getSimpleName(), BoxesRunTime.boxToLong((long)this.currentCount())}));
    }

    public PostgreSQLConnection(Configuration configuration, ColumnEncoderRegistry encoderRegistry, ColumnDecoderRegistry decoderRegistry, EventLoopGroup group, ExecutionContext executionContext) {
        this.configuration = configuration;
        this.encoderRegistry = encoderRegistry;
        this.decoderRegistry = decoderRegistry;
        Connection.class.$init$((Connection)this);
        this.connectionHandler = new PostgreSQLConnectionHandler(configuration, encoderRegistry, decoderRegistry, this, group, executionContext);
        this.currentCount = PostgreSQLConnection$.MODULE$.Counter().incrementAndGet();
        this.com$github$mauricio$async$db$postgresql$PostgreSQLConnection$$preparedStatementsCounter = new AtomicInteger();
        this.internalExecutionContext = executionContext;
        this.parameterStatus = new HashMap();
        this.com$github$mauricio$async$db$postgresql$PostgreSQLConnection$$parsedStatements = new HashMap();
        this.authenticated = false;
        this.com$github$mauricio$async$db$postgresql$PostgreSQLConnection$$connectionFuture = Promise$.MODULE$.apply();
        this.recentError = false;
        this.queryPromiseReference = new AtomicReference<None$>(None$.MODULE$);
        this.currentQuery = None$.MODULE$;
        this.currentPreparedStatement = None$.MODULE$;
        this.version = new Version(0, 0, 0);
        this.notifyListeners = new CopyOnWriteArrayList();
        this.queryResult = None$.MODULE$;
    }
}

