/*
 * Decompiled with CFR 0.152.
 */
package com.github.mauricio.async.db.postgresql.column;

import com.github.mauricio.async.db.column.ColumnDecoder;
import com.github.mauricio.async.db.column.ColumnEncoder;
import com.github.mauricio.async.db.column.ColumnEncoderDecoder;
import com.github.mauricio.async.db.exceptions.DateEncoderNotAvailableException;
import com.github.mauricio.async.db.general.ColumnData;
import com.github.mauricio.async.db.postgresql.column.PostgreSQLTimestampEncoderDecoder$;
import com.github.mauricio.async.db.postgresql.messages.backend.PostgreSQLColumnData;
import com.github.mauricio.async.db.util.Log$;
import io.netty.buffer.ByteBuf;
import java.nio.charset.Charset;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import org.joda.time.DateTime;
import org.joda.time.LocalDateTime;
import org.joda.time.ReadableDateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePartial;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.DateTimeFormatterBuilder;
import org.joda.time.format.DateTimeParser;
import org.slf4j.Logger;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

public final class PostgreSQLTimestampEncoderDecoder$
implements ColumnEncoderDecoder {
    public static final PostgreSQLTimestampEncoderDecoder$ MODULE$;
    private final Logger log;
    private final DateTimeParser com$github$mauricio$async$db$postgresql$column$PostgreSQLTimestampEncoderDecoder$$optionalTimeZone;
    private final IndexedSeq<DateTimeFormatter> internalFormatters;
    private final DateTimeFormatter internalFormatterWithoutSeconds;

    static {
        new PostgreSQLTimestampEncoderDecoder$();
    }

    private Logger log() {
        return this.log;
    }

    public DateTimeParser com$github$mauricio$async$db$postgresql$column$PostgreSQLTimestampEncoderDecoder$$optionalTimeZone() {
        return this.com$github$mauricio$async$db$postgresql$column$PostgreSQLTimestampEncoderDecoder$$optionalTimeZone;
    }

    private IndexedSeq<DateTimeFormatter> internalFormatters() {
        return this.internalFormatters;
    }

    private DateTimeFormatter internalFormatterWithoutSeconds() {
        return this.internalFormatterWithoutSeconds;
    }

    public DateTimeFormatter formatter() {
        return (DateTimeFormatter)this.internalFormatters().apply(5);
    }

    public Object decode(ColumnData kind, ByteBuf value, Charset charset) {
        DateTime dateTime;
        byte[] bytes = new byte[value.readableBytes()];
        value.readBytes(bytes);
        String text = new String(bytes, charset);
        PostgreSQLColumnData columnType = (PostgreSQLColumnData)kind;
        int n = columnType.dataType();
        switch (n) {
            default: {
                throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
            }
            case 1184: {
                if (columnType.dataTypeModifier() > 0) {
                    dateTime = ((DateTimeFormatter)this.internalFormatters().apply(columnType.dataTypeModifier() - 1)).parseDateTime(text);
                    break;
                }
                dateTime = this.selectFormatter(text).parseDateTime(text);
                break;
            }
            case 1185: {
                dateTime = this.selectFormatter(text).parseDateTime(text);
                break;
            }
            case 1114: 
            case 1115: {
                dateTime = this.selectFormatter(text).parseLocalDateTime(text);
            }
        }
        return dateTime;
    }

    private DateTimeFormatter selectFormatter(String text) {
        return text.contains(".") ? (DateTimeFormatter)this.internalFormatters().apply(5) : this.internalFormatterWithoutSeconds();
    }

    public Object decode(String value) {
        throw new UnsupportedOperationException("this method should not have been called");
    }

    public String encode(Object value) {
        block7: {
            String string;
            block3: {
                Object object;
                block6: {
                    block5: {
                        block4: {
                            block2: {
                                object = value;
                                if (!(object instanceof Timestamp)) break block2;
                                Timestamp timestamp = (Timestamp)object;
                                string = this.formatter().print((ReadableInstant)new DateTime((Object)timestamp));
                                break block3;
                            }
                            if (!(object instanceof Date)) break block4;
                            Date date = (Date)object;
                            string = this.formatter().print((ReadableInstant)new DateTime((Object)date));
                            break block3;
                        }
                        if (!(object instanceof Calendar)) break block5;
                        Calendar calendar = (Calendar)object;
                        string = this.formatter().print((ReadableInstant)new DateTime((Object)calendar));
                        break block3;
                    }
                    if (!(object instanceof LocalDateTime)) break block6;
                    LocalDateTime localDateTime = (LocalDateTime)object;
                    string = this.formatter().print((ReadablePartial)localDateTime);
                    break block3;
                }
                if (!(object instanceof ReadableDateTime)) break block7;
                ReadableDateTime readableDateTime = (ReadableDateTime)object;
                string = this.formatter().print((ReadableInstant)readableDateTime);
            }
            return string;
        }
        throw new DateEncoderNotAvailableException(value);
    }

    public boolean supportsStringDecoding() {
        return false;
    }

    private PostgreSQLTimestampEncoderDecoder$() {
        MODULE$ = this;
        ColumnEncoder.class.$init$((ColumnEncoder)this);
        ColumnDecoder.class.$init$((ColumnDecoder)this);
        this.log = Log$.MODULE$.getByName(this.getClass().getName());
        this.com$github$mauricio$async$db$postgresql$column$PostgreSQLTimestampEncoderDecoder$$optionalTimeZone = new DateTimeFormatterBuilder().appendPattern("Z").toParser();
        this.internalFormatters = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(1), 6).inclusive().map((Function1)new anonfun.1(), IndexedSeq$.MODULE$.canBuildFrom());
        this.internalFormatterWithoutSeconds = new DateTimeFormatterBuilder().appendPattern("yyyy-MM-dd HH:mm:ss").appendOptional(this.com$github$mauricio$async$db$postgresql$column$PostgreSQLTimestampEncoderDecoder$$optionalTimeZone()).toFormatter();
    }
}

